import re
from ast import literal_eval
import copy

from ..feature_engineering.inversion import reverse_geo_point_coordinates
from ..constants import GEOJSON_POINT_STARTER

def read_wkt_geo_point(geo_point):
    geo_point = re.sub( "POINT {0,1}|\(|\)", "", geo_point )
    geo_point = geo_point.split( " " )
    geo_point = [float( coordinate ) for coordinate in geo_point]
    return geo_point


def create_wkt_geo_point(latitude, longitude):
    return "POINT({} {})".format( longitude, latitude )


def read_geo_point(geo_point, reverse_coordinates):
    geo_point = str( geo_point )
    try:
        if 'point' in str( geo_point ).lower():
            geo_point = read_wkt_geo_point( geo_point )
        else:
            geo_point = literal_eval( geo_point )
        if reverse_coordinates:
            geo_point = reverse_geo_point_coordinates(geo_point)
        return geo_point
    
    except ValueError:
        return 'ValueError : geo_point is not readable'
    pass


def convert_from_list_geo_point_to_geojson(list_geo_point):
    geojson = copy.deepcopy(GEOJSON_POINT_STARTER)
    geojson["geometry"]["coordinates"] = list_geo_point
    return geojson
