import json
import copy
import re
from shapely import wkt
from shapely.ops import transform
from shapely.geometry import Polygon

from ..constants import GEOJSON_POLYGON_STARTER
from ..feature_engineering.inversion import flip, reverse_polygon_coordinates


def read_polygon_string_as_list(string_polygon, polygon_format, reverse_coordinates):
    if polygon_format == "wkt":
        shapely_polygon = convert_polygon_from_wkt_string_to_shapely(string_polygon, reverse_coordinates )
        list_polygon = convert_polygon_from_shapely_to_list(shapely_polygon, reverse_coordinates=False)

    elif polygon_format == "geojson":
        polygon_geojson = json.loads( string_polygon )
        list_polygon = convert_from_geojson_to_list_polygon(polygon_geojson)
        if reverse_coordinates:
            list_polygon = reverse_polygon_coordinates(list_polygon)
    return list_polygon


def convert_polygon_from_list_to_shapely(list_polygon, reverse_coordinates):
    if reverse_coordinates:
        list_polygon = reverse_polygon_coordinates( list_polygon )
    shapely_polygon = Polygon(list_polygon)
    return shapely_polygon


def convert_polygon_from_shapely_to_list(shapely_polygon, reverse_coordinates):
    """
    shapely_polygon : shapely.geometry.polygon.Polygon
    """
    first_axis_coordinates, second_axis_coordinates = shapely_polygon.exterior.coords.xy
    if reverse_coordinates:
        list_polygon = from_coordinates_to_polygon( second_axis_coordinates, first_axis_coordinates )
    else:
        list_polygon = from_coordinates_to_polygon( first_axis_coordinates, second_axis_coordinates )
    return list_polygon


def convert_polygon_from_wkt_string_to_shapely(wkt_string_polygon, reverse_coordinates):
    shapely_polygon = wkt.loads(wkt_string_polygon)
    if reverse_coordinates:
        shapely_polygon = transform(flip, shapely_polygon)
    return shapely_polygon


def convert_polygon_from_shapely_to_wkt_string(shapely_polygon, reverse_coordinates):
    if reverse_coordinates:
        shapely_polygon = transform(flip, shapely_polygon)
    wkt_polygon_string = shapely_polygon.wkt
    return wkt_polygon_string


def from_coordinates_to_polygon(first_axis_coordinates, second_axis_coordinates):
    return [[coord_0, coord_1] for coord_0, coord_1 in zip(first_axis_coordinates, second_axis_coordinates)]
    pass


def convert_from_list_polygon_to_geojson(list_polygon):
    geojson = copy.deepcopy(GEOJSON_POLYGON_STARTER)
    for coordinates in list_polygon:
        geojson["geometry"]["coordinates"][0].append(list(coordinates))
    return geojson


def convert_from_geojson_to_list_polygon(geojson):
    return geojson["geometry"]["coordinates"][0]


def convert_from_list_polygon_to_overpass_geometry(list_polygon):
    """
    polygon must have format :
    [[longitude_1, latitude_1], [longitude_2, latitude_2], ...., [longitude_n, latitude_n]]
    """
    list_polygon = reverse_polygon_coordinates(list_polygon)
    overpass_parameters = str(list_polygon)
    overpass_parameters = re.sub("[\[\],]", "", overpass_parameters)
    overpass_parameters = '(poly:"{}")'.format(overpass_parameters)
    return overpass_parameters
