# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# -*- coding: utf-8 -*-
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
from real_estate_pricing.flow.constants import PARIS_DISTRICTS
from dku_utils import update_one_schema_column
from dates_handling import from_datetime_to_dss_string_date

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# Read recipe inputs
date_boundaries = dataiku.Dataset("date_boundaries")
date_boundaries_df = date_boundaries.get_dataframe()

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
min_date = date_boundaries_df["transaction_date_min"][0]
max_date = date_boundaries_df["transaction_date_max"][0]

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
all_possible_transaction_dates = list(pd.to_datetime(pd.date_range(start=min_date, end=max_date), format="yyyy/MM/dd HH:mm:ss Z"))
all_possible_transaction_dates = [from_datetime_to_dss_string_date(date) for date in all_possible_transaction_dates]

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
districts_on_each_date_df = pd.DataFrame(columns=["census_district", "date"], index=[])

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
for district in PARIS_DISTRICTS:
    district_dates_df = pd.DataFrame(all_possible_transaction_dates, columns=["date"])
    district_dates_df["census_district"] = district
    districts_on_each_date_df = pd.concat([districts_on_each_date_df, district_dates_df])

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
districts_on_each_date_df

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# Compute recipe outputs from inputs
# TODO: Replace this part by your actual code that computes the output, as a Pandas dataframe
# NB: DSS also supports other kinds of APIs for reading and writing data. Please see doc.

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# Write recipe outputs
districts_on_each_date = dataiku.Dataset("districts_on_each_date")
districts_on_each_date.write_with_schema(districts_on_each_date_df)

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
project_key = dataiku.get_custom_variables()["projectKey"]
update_one_schema_column(project_key,
                         "districts_on_each_date",
                         "date",
                         "date")