# Real estate pricing API service

This project also contains an API service : [real_estate_pricing](lambda_service:real_estate_pricing)
[Learn more about DSS and real-time APIs](https://doc.dataiku.com/dss/latest/apinode/index.html).

It is composed of 7 Python endpoints and 1 prediction model endpoint.
Each endpoint can be called separately by passing as parameters the information it requires.


# Endpoints presentation

- Endpoint **geocode_address** has the role to extract latitude and longitude information from any address. It only needs an *address* information as a parameter.

- Endpoint **lookup_census_features** has the role to retrieve the census polygon features associated with any geo point. It only needs a *geo_point* information as a parameter.

- Endpoint **lookup_stations_features** has the role to retrieve the closest station features associated with any geo point. It only needs a *geo_point* information as a parameter.

- Endpoint **lookup_district_time_features** has the role to retrieve the district time features associated with any district. It only needs *district* information as a parameter.

- Endpoint **lookup_polygon_time_features** has the role to retrieve the polygon time features associated with any census polygon. It only needs *census_polygon_name* information as a parameter.

- Endpoint **lookup_subway_stations_time_features** has the role to retrieve the station time features associated with any station. It only needs a *station_name* information as a parameter.

- Endpoint **predict_property_price** has the role to predict the price of a property given its characteristics and both the geospatial and time features that surround its location. It needs the properties characteristics and all the parameters mentioned above.

- Endpoint **wrapup** has the role to call sequentially all the endpoints mentioned above :arrow_up:, as described in the picture below :arrow_down:. It needs the properties characteristics (address, property_type, number_of_rooms, living_surface and number_of_lots) as parameters, then it enriches these features with the results of all the other endpoints calls before calling the **predict_property_price** endpoint and get the model predictions.

![api-services.png](yYFwECukdMqS)

It is not currently possible to use your API node for the backend prediction process within the [Real Estate Pricing webapp](web_app:uZaacFd). 