# Key steps for real estate pricing

- The [inputs_zone](flow_zone:tP9tYN0) has the role to ingest your input datasources.
  - [Learn more about the inputs_zone](article:20).

- The [properties_preprocessing](flow_zone:Tc9kw2a) zone prepares the properties data.
  - [Learn more about this zone](article:24).

- The [subway_stations_preprocessing](flow_zone:rhcQz1q)  transforms the subway stations dataset to project stations into a graph ([What do you mean by "graph" ?](article:32)). It also indexes the station geospatial data so that any geo point can be enriched with this information elsewhere.
  - [Learn more about this zone](article:26).

- The [census_data_preprocessing](flow_zone:NUiXeSU) adds features to the original census dataset. It also indexes the census geospatial data so that any geo point can be enriched with this information elsewhere.
  - [Learn more about this zone](article:27).

- The [properties_geospatial_enrichment](flow_zone:Uam9udZ) is in charge of joining all the spatial data (census, stations, city center) to the preprocessed property sales dataset.
  - [Learn more about this zone](article:28).

- The [properties_time_feature_engineering](flow_zone:5cpRaOZ) applies time feature engineering techniques on the properties' price per square meter.
  - [Learn more about this zone](article:29).

- The [real_estate_pricing](flow_zone:xyEwdSK) splits all the properties data into a train set and a test set. It also contains a deployed machine learning model that is used to score the test set and historize model metrics over time.
  - [Learn more about this zone](article:30).

- The [api_&_webapp](flow_zone:y6A5GuT) isolates all the flow elements that are useful for both the project's webapp, the API services and the [portfolio_pricing](flow_zone:wxvEt5T) zone.
  - [Learn more about this zone](article:31).