from dku_utils.projects.project_commons import get_current_project_and_variables

def get_keys():
    project, variables = get_current_project_and_variables()
    global_vars = variables['standard']

    primary_keys = [global_vars['primary_column_1']]
    secondary_keys = [global_vars['secondary_column_1']]
    key_types = [global_vars['type_1']]
    thresholds = [global_vars['matching_distance_threshold_1']]
    weights = [global_vars['matching_distance_weight_1']]
    for i in range(2, 16):
        if global_vars['add_key_{}'.format(i)]:
            primary_keys.append(global_vars['primary_column_{}'.format(i)])
            secondary_keys.append(global_vars['secondary_column_{}'.format(i)])
            key_types.append(global_vars['type_{}'.format(i)])
            thresholds.append(global_vars['matching_distance_threshold_{}'.format(i)])
            weights.append(global_vars['matching_distance_weight_{}'.format(i)])
        else:
            break
            
    return primary_keys, secondary_keys, key_types, thresholds, weights