from dotenv import load_dotenv
load_dotenv()  # 👈 must come first, before anything else

import os
from flask import Flask
from flask_cors import CORS
from webaiku.extension import WEBAIKU
from .fetch_api import fetch_api

app = Flask(__name__)
WEBAIKU(app, "webapps/bs-reconciliation", int(os.getenv("VITE_API_PORT")))
WEBAIKU.extend(app, [fetch_api])
CORS(app=app, resources={r"/bs_api/*": {"origins": "*"}})

if __name__ == "__main__":
    print("VITE_API_PORT:", os.getenv("VITE_API_PORT"))
    print("DKU_CURRENT_PROJECT_KEY:", os.getenv("DKU_CURRENT_PROJECT_KEY"))
    app.run(host="127.0.0.1", port=int(os.getenv("VITE_API_PORT")), debug=True)
