Edges are the relationships between two nodes of a graph, like roads connecting two points on a map. In the case of drug repurposing, computing the edges for so many different types of nodes means blending data from multiple sources that use different keys to identify genes, diseases, etc. This means that before creating the dataset of edges we need to match nodes to a single identifier. 

# Unique Lookups

Genes are the central node in this particular graph, and in the field can take on various identifers based on the research institute that provides the data. For instance, the main [Gene_Nodes](dataset:Gene_Nodes) are based on data from the National Center for Biotechnology Information (NCBI). NCBI uses a system called Entrez Gene to classify sequenced genes for multiple organisms. Entrez Gene serves as the unique gene identifier in this graph network ; to facilitate the look up between Entrez Gene and other gene identifiers, NCBI provides references which are downloaded and extracted in [Genes](flow_zone:fo5wszb).  The Ensembl/Entrez lookup table is used to map Gene Nodes to the correct [Anatomy Nodes](flow_zone:default), while the Entrez/GO mapping links Gene Nodes to their respective [Gene Ontologies](flow_zone:tq6pmMD). Finally, some lookups like [Drug_Genes](recipe:compute_Drug_Genes) and [Pathways_with_Genes](recipe:compute_Pathways_with_Genes) use the gene symbol to link information. 

For the Disease Nodes the common lookup is between the National Institute of Health's UMLS Concept Unique Identifier (UMLS_CUI) and the Online Mendelian Inherentence in Man idetentifiers (OMIM_CUI).

# Exporting Relationships

Joining two datasets, such as Diseases and Genes, implicitly creates a relationship between these two node types - different diseases are associated with certain genes and vice versa. To make this connection clear in the graph database, the Neo4J plugin offers a recipe to export relationships. For this step, you need a dataset that has a unique column for two different types nodes, such as the post-join [Disease_Gene](dataset:Disease_Gene) dataset. When using the export recipe, you can define the relationship between the two nodes using a text field.

In some cases, there may be additional information about this link, such as a weight or strength to this relationship. These details of the relationship, and any unique identifiers for it, can also be configured during the relationship export. Additionally, any reference to node labels that do not exist in the database will be created. It is important to ensure the labeling convention for nodes is consistent between the node and relationship exports, such as 'Gene ID', otherwise the plugin will assume a previously unseen label (for example, 'Gene Number') is a new type of node in the graph. 