# -*- coding: utf-8 -*-
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu
from clusterOrdering import order_cluster

# Read recipe inputs
customers_clv_clustered = dataiku.Dataset("customers_clv_clustered")
customers_clv_clustered_df = customers_clv_clustered.get_dataframe()


# Compute recipe outputs from inputs
# TODO: Replace this part by your actual code that computes the output, as a Pandas dataframe
# NB: DSS also supports other kinds of APIs for reading and writing data. Please see doc.

customers_clv_clustered_df = order_cluster('cluster_labels', 
                                          'CLV',
                                          customers_clv_clustered_df,
                                          True)

customers_clv_clusters_df = customers_clv_clustered_df # For this sample code, simply copy input to output

# Write recipe outputs
customers_clv_clusters = dataiku.Dataset("customers_clv_clusters")
customers_clv_clusters.write_with_schema(customers_clv_clusters_df)
