# -*- coding: utf-8 -*-
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu
from clusterOrdering import order_cluster

# Read recipe inputs
customers_train_with_CLV_clustered_recency = dataiku.Dataset("marketing_recency_raw_clusters")
customers_train_with_CLV_clustered_recency_df = customers_train_with_CLV_clustered_recency.get_dataframe()

# Compute recipe outputs from inputs
# TODO: Replace this part by your actual code that computes the output, as a Pandas dataframe
# NB: DSS also supports other kinds of APIs for reading and writing data. Please see doc.

customers_train_with_CLV_clustered_recency_df = order_cluster('cluster_labels', 
                                                              'MarketingRecency',
                                                              customers_train_with_CLV_clustered_recency_df,
                                                              False)

customers_recency_score_df = customers_train_with_CLV_clustered_recency_df # For this sample code, simply copy input to output

# Write recipe outputs
customers_recency_score = dataiku.Dataset("marketing_recency_clusters")
customers_recency_score.write_with_schema(customers_recency_score_df)
