# -*- coding: utf-8 -*-
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu
from lifetimes import BetaGeoFitter, GammaGammaFitter
import os

# Read recipe inputs
customers_rfm_scored = dataiku.Dataset("customers_with_all_features")
df = customers_rfm_scored.get_dataframe()


# Compute recipe outputs from inputs

bgf = BetaGeoFitter(penalizer_coef=0.0)
bgf.fit(df['Frequency'], 
        df['StatisticalRecency'], 
        df['CustomerAge'])

ggf = GammaGammaFitter(penalizer_coef=0)
ggf.fit(df['Frequency'],
        df['MonetaryValue'])

# Write recipe outputs
probabilitic_models = dataiku.Folder("k79txFQX")
probabilitic_models_info = probabilitic_models.get_info()
bgf.save_model(os.path.join(probabilitic_models_info['path'],'bgf.pkl'))
ggf.save_model(os.path.join(probabilitic_models_info['path'],'ggf.pkl'))