# -*- coding: utf-8 -*-
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu
from sklearn.metrics import mean_absolute_error, mean_squared_error, max_error, median_absolute_error, r2_score, explained_variance_score

# Read recipe inputs
customers_log_pred = dataiku.Dataset("customers_log_pred")
customers_log_pred_df = customers_log_pred.get_dataframe()


# Compute recipe outputs from inputs
# TODO: Replace this part by your actual code that computes the output, as a Pandas dataframe
# NB: DSS also supports other kinds of APIs for reading and writing data. Please see doc.


y_true = customers_log_pred_df['CLV']
y_pred = 10**customers_log_pred_df['prediction']

model_log_metrics_df = pd.DataFrame(index=[1])

model_log_metrics_df['mean absolute error'] = mean_absolute_error(y_true, y_pred)
model_log_metrics_df['median absolute error'] = median_absolute_error(y_true, y_pred)
model_log_metrics_df['mean squared error'] = mean_squared_error(y_true, y_pred)
model_log_metrics_df['root mean squared error'] = mean_squared_error(y_true, y_pred, squared=False)
model_log_metrics_df['max error'] = max_error(y_true, y_pred)
model_log_metrics_df['r2 score'] = r2_score(y_true, y_pred)
model_log_metrics_df['explained variance score'] = explained_variance_score(y_true, y_pred)


# Write recipe outputs
model_log_metrics = dataiku.Dataset("model_log_metrics")
model_log_metrics.write_with_schema(model_log_metrics_df)