# -*- coding: utf-8 -*-
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu
from lifetimes import BetaGeoFitter, GammaGammaFitter
import os

# Read recipe inputs
probabilitic_models = dataiku.Folder("k79txFQX")
probabilitic_models_info = probabilitic_models.get_info()
customers_rfm_scored = dataiku.Dataset("customers_with_all_features")
customers_rfm_scored_df = customers_rfm_scored.get_dataframe()

# Compute recipe outputs from inputs

df = customers_rfm_scored_df[['CustomerID','Frequency','StatisticalRecency','CustomerAge','MonetaryValue','CLV']]

bgf = BetaGeoFitter()
bgf.load_model(os.path.join(probabilitic_models_info['path'],'bgf.pkl'))

ggf = GammaGammaFitter()
ggf.load_model(os.path.join(probabilitic_models_info['path'],'ggf.pkl'))

df['probability_alive'] = bgf.conditional_probability_alive(df['Frequency'], 
                                                            df['StatisticalRecency'], 
                                                            df['CustomerAge'])
df['pred_num_tx'] = bgf.conditional_expected_number_of_purchases_up_to_time(int(int(dataiku.get_custom_variables()['forward_window'])*30.5),
                                                                            df['Frequency'], 
                                                                            df['StatisticalRecency'], 
                                                                            df['CustomerAge'])
df['pred_avg_sale'] = ggf.conditional_expected_average_profit(df['Frequency'],
                                        df['MonetaryValue'])
df['pred_clv'] = ggf.customer_lifetime_value(bgf,
                            df['Frequency'], 
                            df['StatisticalRecency'], 
                            df['CustomerAge'],
                            df['MonetaryValue'],
                            int(dataiku.get_custom_variables()['forward_window']))

# Write recipe outputs
probabilistic_clv = dataiku.Dataset("probabilistic_clv")
probabilistic_clv.write_with_schema(df)
