![Screen Shot 2022-02-24 at 3.56.45 PM.png](o0G4lOJZg8Vm)
 
このフローゾーンでは、さまざまな手法を使用して顧客の CLV を予測します。

このプロジェクトでは、CLV を計算する 3 つの手法を比較します。
 
- 確率的モデル。このモデルでは、顧客ごとの RFM 値に近似させた確率分布を求めます。各顧客の取引履歴により定義される購入行動に基づくモデルです。
- 機械学習モデル。機械学習モデルでは、確率的モデルよりも多くの特徴量が必要になる場合があります。このプロジェクトでは、ランダムフォレストモデルを使用します。
- 組み合わせモデル。
 
> :warning:  プロジェクトを最初に構築するときは、すべてのモデルを再トレーニングする必要があります。このサンプルプロジェクトで使用されているモデルを含め、さまざまなモデルのトレーニングを行い、異なる前処理やハイパーパラメーターなどの組み合わせをテストすることができます。
一概にどの手法が最適かを決めることはできないので、各手法の性能メトリクスを比較して、各自のニーズに最適な手法を選ぶ必要があります。

 
これら 3 つの手法は、フローゾーンで [Tag（タグ）ビュー](https://knowledge.dataiku.com/latest/courses/flow-views-and-actions/flow-views-concept-summary.html).を使用して確認できます。

 
# 確率的モデル

このプロジェクトの確率的モデルでは、既存の[Lifetimesライブラリ](https://lifetimes.readthedocs.io/en/master/index.html)を使用します。
 
この手法について詳しくは、[Appendix](article:16)をご覧ください。この手法では2つのモデルは活用しています

- FrequencyとRecencyを用いて、顧客の将来の購入回数を予測しようとするBetaGeoモデル。
- FrequencyとMonetary Valueを用いて、顧客の取引量を予測しようとするGammaGammaモデル。

この2つのモデルを組み合わせることで、顧客の顧客生涯価値を予測することができます。
 
確率的モデルでは、顧客が特定の基準日においてアクティブである確率も計算できます。この特徴量は [このデータセット](dataset:probabilistic_clv).で確認できます。

評価レシピと同じ指標を、pythonレシピを使って計算しています。結果はかなり悪く、これはモデルがパラメータの適合を助けるためにターゲットがない、完全に教師なしであるという事実によって説明できます。しかし、もし目的が予測されたCLVに応じて顧客をセグメント化することであるなら、確率的な予測を使用することができます。
 
# 機械学習モデル
 
機械学習の手法では、2 通りの方法で CLV を予測します。
1 つ目は基本的な方法で、ランダムフォレストを使用して将来の CLV を直接予測します。DSS による分析は[こちら](analysis:wMUPKngl)で確認できます。

事前に構築したすべての特徴をモデルに含め、ターゲットとしてCLVを選択し、目的指標としてRoot Mean Square Errorを選択します。結果として、重要度の大部分は２つの変数に特定できます。TotalPrice_sum と TotalPrice_sum_stdev は、それぞれ特徴の重要性の 68% と 25% を占め、次に重要な変数は 1%に留まります。TotalPrice_sum は、その顧客の過去の取引総額を表し、将来の取引に関する良い指標を実際に与えるはずです。2つ目は、その変数が顧客の生涯にわたってこの量であったかを見るもので、それは傾向変数として解釈されます。

このモデルは、非常に少数の変数に依存しており、したがって不安定であるという事実について、いくつかの懸念が提起される可能性があります。このモデルを改善する1つの方法は、CLV を TotalPrice_sum で割ることによって、スケーリング変数として機能する初期の TotalPrice_sum でターゲットを正規化することでしょう。両方が同じ時間枠に関連していることを確認するために、TotalPrice_sumは、CLVと同じ時間ウィンドウにスケールバックするために、CustomerAgeでさらに正規化することができます。

2 つ目の方法でもランダムフォレストを使用しますが、直接 CLV を予測するのではなく、log```log(CLV)```予測します。この手法は通常、歪みのあるターゲットに対して良い結果を得ることができます。DSS による分析は [こちら](analysis:kfbcPFMx)で確認できます。
データを使用してモデルの再トレーニングを行う必要があります。

この2つ目のモデルでは、TotalPrice_sumはさらに重要で、変数の重要度が1%を超える唯一の特徴量であり、変数の重要度の98%を占めています。TotalPrice_sumは、過去の顧客価値と解釈できるので、モデルのパフォーマンスを向上させるために、この自己相関の知識を含めて、モデルの将来の反復を行うことが望ましいかもしれません。


 
# 組み合わせモデル

最後の手法では、確率的モデルを使用し、生成された出力を機械学習アルゴリズムの新しい特徴量として使用します。ここでもランダムフォレストを使用します。DSS による分析は[こちら](analysis:mYw7PUmC)で確認できます。

データを使用してモデルの再トレーニングを行う必要があります。

このアプローチは、変数の重要度の4%を占めるpred_CLVのような追加された特徴のおかげで、最初のMLモデルよりわずかに良い結果を得ることができました。

# モデルの性能

モデルは、evaluate（評価）レシピを使用して、サンプル内で評価されます。このレシピをホールドアウトデータセットに適用することで、パフォーマンスメトリクスがオーバーフィッティングによって影響を受けないことを確認することができます。結合されたモデルはCLVランダムフォレストをわずかに上回り、より良いパフォーマンスを示しています。log(CLV)の性能は低く、確率的モデルの性能は非常に悪い。この性能は絶対値で計算されているが、もし我々が予測値に関して顧客の順位を知りたいだけであれば、実際の値よりはるかに小さい値を予測する確率的モデルでさえ、洞察に値するかも知れません。
