# Method presentation

## Acronym definition
**RFM** is a customer segmentation technique aiming to categorize your customers among three axes: 

- Their **R**ecency axis represents the time separating the RFM computation date from their last purchase. 
  - This information can be computed after you know the days separating each customer's last transaction from the RFM reference date.

- Their **F**requency axis represents how frequently they purchase.
  - This information can be computed after you know how many transactions each customer did.

- Their **M**onetary axis value represents the revenue you get from them.
  - *This information can be computed  after you know, for each customer*:
    - *The total amount generated by her/his baskets*.
    - *OR her/his the average basket*.



**Note**: Our solution adds another dimension to the three mentioned above, which is the **D** for **D**ensity. 
- **D**ensity represents the number of items purchased by your customers.

___
## From customer features to RFM scores

Once you have the **RFM** core information, the idea of the method is to chunk it into groups. People generally tend to chunk each **R**, **F**, **M** core feature into groups of scores between 1 and 5. The higher these scores, the better. This division will lead to highly interpretable groups of customers.
This solution will propose two different customer features chunking strategies ([Learn more about the RFM scores computation techniques](article:14)).

### Example

- A customer having a **R**ecency *(resp. "**F**requency" OR  "**M**onetary value")* score of **5** means that it is one of your most recent customers *(resp. "one of the most frequent customers" OR "one of the most important buyers")*.
- Conversely, a customer having a **R**ecency *(resp. "**F**requency" OR  "**M**onetary value")* score of **1** means that it is one of your oldest customers *(resp. "one of the less frequent customers" OR "one of the less important buyers")*.

### Computation process

#### Customer features computation
Assume you have the following customer features :arrow_down: : 
![customer_features.png](4LYzWGCkzKi9)

#### Customer features chunking
You can then chunk each feature, into groups from **1** *(poor score)* to **5** *(top score)* :arrow_down: :
**Note:** like in the example below :arrow_down: , the solution will use a color palette where: 
- The darker/colder colors will represent the worst scores.
- The lighter/warmer colors will represent the best scores.
![customer_recency_frequency_monetary_value_scores.png](fEoZlKKtY3gv)


___
## From customer RFM scores to RFM segments and global scores

Once you assessed all the RFM scoring information: 
- Concatenating the scores will give you a **RFM segment**.
- Summing the scores will give you a global **RFM score**.

Both of them will help you to have a clear understanding of each customer's purchasing behavior relative to all your customers.
The picture below illustrates this process :arrow_down: : 
![customer_rfm_segments_and_scores.png](naLoxQO4T9dU)

As you can see, we now get a customer segmentation based on their purchasing behavior. 
However, having a chunking of 5 scores for each **R**ecency, **F**requency and **M**onetary value axis can potentially lead to getting 5 x 5 x 5 = **125** customer segments, which can be challenging to manage. For this reason, we propose you reduce this complexity by identifying your **RF** segments ([Learn more about FM segments identification](article:23)).


