# Concept definition
[Wikipedia's definition: ](https://en.wikipedia.org/wiki/Quantile) 
> In statistics and probability, **quantiles** are cut points dividing the range of a probability distribution into continuous intervals with equal probabilities, or dividing the observations in a sample in the same way. There is one fewer quantile than the number of groups created. 

> Common quantiles have special names, such as quartiles (four groups), deciles (ten groups), and percentiles (100 groups). The groups created are termed halves, thirds, quarters, etc., though sometimes the terms for the quantile are used for the groups created, rather than for the cut points.


# Examples
- The most famous quantile is the median: i.e. the value separating a feature into two equal parts.
  - A feature having a median of 20 means that 50% of its values are under 20.
- The X-th decile gives us the feature threshold leading to having 10*X percent of the feature values under it.
  - A feature having a 2nd decile of  75 means that 20% of its values are under 75.

[How to use the quantiles for RFM scoring](article:19)?


