# How does it work?
In ***RFM Segmentation***, the quantile method will use deciles to compute the feature chunks.
For example, if we want to divide the total basket into 5 chunks for computing our **M**onetary value axis, we will look at the deciles n°2, 4, 6 and 8.
- Values under the decile n°2 will lead to a **M**onetary value of 1.
- Values above the decile n°2 and under the decile n°4 will lead to a **M**onetary value of 2.
- Values above the decile n°4 and under the decile n°6 will lead to a **M**onetary value of 3.
- Values above the decile n°6 and under the decile n°8 will lead to a **M**onetary value of 4.
- Values above the decile n°8 will lead to a **M**onetary value of 5.


# More concretely

Assume we have the following customer "total basket" distribution in our dataset of 2500 customers :arrow_down:: 

![total_basket_distribution.png](09velPXoCMT5)

Computing the deciles leads to the below results:
- Decile n°2  = 2895.67 --> Values below this decile will have a **M**onetary value of 1.
- Decile n°4  = 3567.46  --> Values in ]2895.67 ; 3567.46] will have a **M**onetary value of 2.
- Decile n°6  = 4500.87  --> Values in ]3567.46 ; 4500.87] will have a **M**onetary value of 3.
- Decile n°8  = 5050.62  --> Values in ]4500.87 ; 5050.62] will have a **M**onetary value of 4.
- Finally, values above 5050.62 will have a **M**onetary value of 5.


Thus, applying the quantile method would lead to the following **M**onetary value scores distribution :arrow_down::  

![monetary_value_scores_distribution_quantile_method.png](Y2sO3YPT5Enw)


Each of the 5 segments has 500 customers :arrow_down:: 
![monetary_value_scores_counts_quantile_method.png](tHeXs30kMsVP)
- **NOTE**: Depending on your data content, you could have quantiles vampirizing others. This can occur if you have many duplicate values in your columns.



