# Flow zone presentation

The [RFM Propagation Preprocessing](flow_zone:NrEldBd) is dedicated to aggregating the transactions data at the **customer_id** x **month of the year** granularity so that we get, for each month a customer purchased, the features that are used to apply the RFM scoring method. 
Contrary to the [rfm_preprocessing](article:28), it assesses the customer's RFM in a period larger than the one defined with the [dates filtering strategy](article:43). 

![rfm_propagation_preprocessing.png](Df8MD4GFBRw9)


- Recipe [compute_transactions_for_rfm_propagation](recipe:compute_transactions_for_rfm_propagation) filters the transactions data on transactions included in the range [propagation_start_date; propagation_end_date], where:
  - "propagation_start_date" is initially the date defined in your application ([more details in the "RFM propagation" section](article:40)).
      - This date can be updated each time your flow will be built if you activate the project's automation ([more details in the "Automation" section](article:42)).
  - "propagation_end_date" is the date at the moment you build your flow.

- Recipe [compute_propagation_customer_baskets](recipe:compute_propagation_customer_baskets) aggregates the data at the **customer_id** x **transaction_id** granularity so that we can have the information of:
  - The total of the customer transactions basket.
  - The total number of items purchased in customer transactions.

- Recipe [compute_customer_first_and_last_transactions](recipe:compute_customer_first_and_last_transactions) computes, for each customer, the information of its first and last transaction dates.


- Recipe [compute_propagation_customer_monthly_baskets](recipe:compute_propagation_customer_monthly_baskets) aggregates the data at the **customer_id** x **month of year** granularity so that we can have the information of:
  - The "first" and "last" monthly customer purchase dates. 
  - The count of distinct transactions done by each customer.
  - The sum of customer baskets amounts.
  - The sum of the number of items purchased by customers.

- Recipe [compute_propagation_months](recipe:compute_propagation_months) computes all the **months of year** included in the period of the RFM propagation.

- Recipe [compute_propagation_distinct_customers](recipe:compute_propagation_distinct_customers) aggregates the data at the **customer_id** so that we get the list of all the customers that purchased during the RFM propagation period.

- Recipe [compute_propagation_possible_customer_montly_interactions](recipe:compute_propagation_possible_customer_montly_interactions) joins datasets [propagation_months](dataset:propagation_months) and [propagation_distinct_customers](dataset:propagation_distinct_customers) so that we get a dataset containing all possible customers monthly interactions. It leads to a dataset having the granularity **customer_id** x **month of the year** for all months existing in the RFM propagation period. 

- Recipe [compute_propagation_customer_montly_interactions](recipe:compute_propagation_customer_montly_interactions) retrieves in dataset [propagation_possible_customer_montly_interactions](dataset:propagation_possible_customer_montly_interactions) the information of all monthly interactions coming from dataset [propagation_customer_monthly_baskets](dataset:propagation_customer_monthly_baskets).

- Now customer monthly interactions are linked with all the batch historical months, we look for customer behavior in the range [focus_month - (T + 1); focus_month -1], for each month; where **T** corresponds to the number of months taken into account when the RFM was computed in the reference period. Recipe [compute_propagation_customer_purchasing_actions](recipe:compute_propagation_customer_purchasing_actions) does exactly this and aggregates: 
  - Customer's first and last purchase date.
      - Later, the difference between each "focus_month" and the "last purchase date" will allow computing the feature "days_since_last_transaction", which will then be used to apply the **R**ecency scoring method learned in the [rfm_segmentation zone](article:30). 
      - The difference between "last" and "first" purchase dates will lead to the "days_between_first_and_last_transaction" that can then be used for further analysis or data enrichment.
  - The count of customers' monthly transactions: this feature will be used to apply the **F**requency scoring method.
  - The sum of customer baskets amounts: this information will later be used to apply the **M**onetary value scoring method learned in the [rfm_segmentation zone](article:30). 
  - The sum of the number of items purchased by customers: similarly, this information will later be used to apply the **D**ensity scoring ([What is this "Density" ?](article:13)) learned in the [rfm_segmentation zone](article:30).

Then the rfm propagation can be done [see the corresponding article](article:32).