# Section presentation

The Automation section allows you to activate the project automation. By doing this, the project will be able to refresh customers' RFM data automatically over time.

![dataiku_app_automation.png](IIPWbFXafowP)

## Section interactions

### Automation strategy
![dku_app_automation_strategy.png](P4dD84a5fnaq)

This section lets you configure which parameters you want to be updated once you enable the automation.

Its content can vary depending on your application parameters. The below matrix shows the possible situations to respect the automation prerequisites :arrow_down::  
![dku_app_automation_settings_matrix.png](mJDoJTBI8qJU)


**Section parameters:**
- *Enable flow automation*: This parameter will let you choose if you want or not to enable the flow automation or not.
- Reference period automation settings:
  - *Update RFM scoring*: This parameter will let you choose if you want to update the RFM scoring method.
  :warning:: By doing this, you will have a brand new way to segment your customers: yesterday's champions (resp. hibernating) customers could be imputed to a different segment. 
- Larger period automation settings:
  - *Update propagation start*: This parameter will let you choose if you want to update the propagation start date you defined in [RFM propagation](article:40) each time your flow will be rebuilt.


### Activate flow automation
![dku_app_activate_flow_automation.png](MU9LfmVTpsbT)

Once you validate all the automation prerequisites, clicking on the *ACTIVATE* button must lead to a scenario success.


Once the scenario succeeded, you can tune the scenario [refresh_flow_over_time](scenario:REFRESH_FLOW_OVER_TIME) so that you define triggers that will refresh all the flow depending on your own business needs.

The picture below showcases what the trigger definition looks like. In this example, the trigger will execute the flow refresh each last day of the month at 23:59 :

![dku_app_refresh_flow_over_time.png](QQWCGkaV1qGo)


Many different triggers could be set ([See our official documentation about triggers](https://doc.dataiku.com/dss/latest/scenarios/triggers.html)) to adapt the scenario execution to your business needs.



