# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# -*- coding: utf-8 -*-
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
import datetime

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
from rfm_segmentation.dku_utils import get_current_project_and_variables, update_one_schema_column
from rfm_segmentation.dates_handling import from_datetime_to_dss_string_date, compute_future_date

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
project, variables = get_current_project_and_variables()
app_variables = variables["standard"]

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
rfm_propagation_start_date_year = app_variables["rfm_propagation_start_date_year_app"]
rfm_propagation_start_date_month = app_variables["rfm_propagation_start_date_month_app"]
rfm_propagation_end_date_year = app_variables["rfm_propagation_end_date_year_app"]
rfm_propagation_end_date_month = app_variables["rfm_propagation_end_date_month_app"]

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
propagation_start_date = datetime.datetime(rfm_propagation_start_date_year, rfm_propagation_start_date_month, 1)
propagation_end_date = datetime.datetime(rfm_propagation_end_date_year, rfm_propagation_end_date_month, 1)
propagation_end_date = compute_future_date(propagation_end_date, "months", 1)

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
propagation_dates = []
propagation_years = []
propagation_months = []
propagation_dates_at_month_end = list(pd.date_range(start=propagation_start_date, end=propagation_end_date, freq="m"))
for pandas_timestamp in propagation_dates_at_month_end:
    timestamp_year = pandas_timestamp.year
    propagation_years.append(timestamp_year)
    timestamp_month = pandas_timestamp.month
    propagation_months.append(timestamp_month)
    datetime_date_at_month_start = datetime.datetime(timestamp_year, timestamp_month, 1)
    dss_date_at_month_start = from_datetime_to_dss_string_date(datetime_date_at_month_start)
    propagation_dates.append(dss_date_at_month_start)

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
propagation_months_df = pd.DataFrame({"rfm_reference_date": propagation_dates,
                                      "rfm_reference_year": propagation_years,
                                      "rfm_reference_month": propagation_months},
                                     index=range(len(propagation_dates)))
propagation_months_df["rfm_reference_month_start"] = propagation_months_df["rfm_reference_date"]

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# Write recipe outputs
propagation_months = dataiku.Dataset("propagation_months")
propagation_months.write_dataframe(propagation_months_df, infer_schema=False, dropAndCreate=True)
#propagation_months.write_with_schema(propagation_months_df)

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
for date_column in ["rfm_reference_date", "rfm_reference_month_start"]:
    update_one_schema_column(project, "propagation_months", date_column, "date")