# 手法の説明

## 略語の定義
**RFM**は、顧客を3つの軸で分類することを目的とした顧客セグメンテーション手法です。

- **R**ecency軸は、RFM計算日と顧客の最後の購入との間の時間 を表します。
  - この情報は、各顧客の最後の取引とRFM基準日の間の日数がわかれば、計算できます。

- **F**requency軸は、顧客がどれくらいの頻度で購入したかを表しています。
  - この情報は、顧客の取引回数に基づいて計算されます。

- **M**onetary軸の値は、その顧客から得られる収益を表しています。
  - *この情報は、各顧客の以下の情報に基づいて計算されます。*
    - *バスケットによって生成された金額の合計*
    - *または、バスケット金額の平均値*


**注** このソリューションでは、上記の3つの要素に加え、もう1つの要素である **D**（Density: 密度）を追加しています。
- **D**は顧客が購入した商品の数量を表します。

___
## 顧客の特徴からRFMスコアへ

**RFM**のコア情報が得られたら、それをグループに分けるというのがこの手法の考え方です。一般的には、**R**、**F**、**M**の各コアフィーチャーを1～5のスコアでグループに分割します。このスコアが高ければ高いほど良い、というわけではありません。このように分けることで、解釈しやすい顧客グループを作ることができます。
このソリューションでは、2つの異なる顧客特徴量の分類戦略を提案します([RFMのスコアリング方法について詳しく知る](article:14))。

### 例

- **R**ecency *(**F**requency、**M**onetary)*のスコアが**5**の顧客は、最も新しい顧客 *(最も頻繁に訪れる顧客、最も金額的に重要な顧客)*であることを意味します。
- 逆に、**R**ecency *(**F**requency、**M**onetary)*のスコアが**1**の顧客は、最も古い顧客 *(もっとも頻度の少ない顧客、最も金額的に重要でない顧客)*の一人であることを意味しています。

### 計算の流れ

#### 顧客特徴量の計算
以下のような顧客特徴量があるとします:arrow_down: : 
![customer_features.png](4LYzWGCkzKi9)

#### 顧客特徴量の分類
次に、各特徴を **1** *(スコアが低い)* から **5** *(スコアが高い)* までのグループに分けて分類します :arrow_down: :
**注:** 以下の例のように :arrow_down: ソリューションでは、カラーパレットが使用されます。
- 暗い/冷たい色は、最悪のスコアを表します。
- より明るい/暖かい色は、最高のスコアを表します。
![customer_recency_frequency_monetary_value_scores.png](fEoZlKKtY3gv)

___
## 顧客RFMスコアからRFMセグメントとグローバルスコアへ

全てのRFM スコア情報を評価後、
- スコアを連結して、**RFMセグメント**が得られます。
- スコアを合計して、グローバルな **RFM スコア** が得られます。

この2つは、各顧客について、全顧客に対する相対的な購買行動を明確に理解するために役立ちます。
下の図は、このプロセスを示しています :arrow_down: : 
![customer_rfm_segments_and_scores.png](naLoxQO4T9dU)

このようにして、購買行動に基づいた顧客セグメンテーションを得ることができます。
しかし、**R**最新度、**F**頻度、**M**金額でそれぞれ5つのスコアが分類されると、5 x 5 x 5 = **125** の顧客セグメントとなり、管理が困難になる可能性があります。そこで、この複雑さを軽減するために、**RF**セグメントを識別することを提案します ([FMセグメントの識別について詳しくはこちら](article:23))。

