import dataiku
import requests
import json
import pandas as pd
import requests
def get_project_variables(variable_format, variable_name):
    project_key = dataiku.get_custom_variables()["projectKey"]
    client = dataiku.api_client()
    project = client.get_project(project_key)
    variables = project.get_variables()
    variable_value = variables[variable_format][variable_name]
    return(variable_value)

def get_query_text(query_url):
    response = requests.get(query_url)
    return(response.text)

def state_name_list(path):
    all_state_names_query_url = path
    all_state_names_query_text = get_query_text(all_state_names_query_url)
    all_state_names_query_result_list = json.loads(all_state_names_query_text)
    all_state_names_df = pd.DataFrame(all_state_names_query_result_list[1:],columns=all_state_names_query_result_list[0])
    state_nums_list = list(all_state_names_df["state"].unique())
    return(state_nums_list)

def get_tracts_code_table(state_nums_list, year, census_code, census_api_key):
    all_tracts_table = pd.DataFrame()
    for state in state_nums_list:
        print("state: " + state)
        try:
            state_all_tracts_query_url = f"https://api.census.gov/data/{year}/acs/acs5?get=NAME,group({census_code})&for=tract:*&in=state:{state}&key={census_api_key}"
            state_all_tract_names_query_text = get_query_text(state_all_tracts_query_url)
            state_all_tract_names_query_result_list = json.loads(state_all_tract_names_query_text)
            state_all_tract_names_df = pd.DataFrame(state_all_tract_names_query_result_list[1:], columns=state_all_tract_names_query_result_list[0])
            df = state_all_tract_names_df.iloc[:, 1:]
            
            # Use pd.concat instead of append
            all_tracts_table = pd.concat([all_tracts_table, df], ignore_index=True)
        except Exception as e:
            print(f"Error processing state {state}: {e}")
            continue
    return all_tracts_table


def get_county_code_dataset(state_nums_list, year, census_code, census_api_key):
    all_county_df = pd.DataFrame()
    for state in state_nums_list:
        try:
            state_all_county_query_url = f"https://api.census.gov/data/{year}/acs/acs5/profile?get=NAME,group({census_code})&for=county:*&in=state:{state}&key={census_api_key}"
            state_all_county_names_query_text = get_query_text(state_all_county_query_url)
            state_all_county_names_query_result_list = json.loads(state_all_county_names_query_text)
            state_all_county_names_df = pd.DataFrame(state_all_county_names_query_result_list[1:], columns=state_all_county_names_query_result_list[0])
            df = state_all_county_names_df.iloc[:, 1:]
            
            # Use pd.concat instead of append
            all_county_df = pd.concat([all_county_df, df], ignore_index=True)
        except Exception as e:
            print(f"Error processing state {state}: {e}")
            continue
    return all_county_df


