# This sample code helps you get started with the custom scenario API.
#For more details and samples, please see our Documentation

import dataiku 
from dataiku.scenario import Scenario

scenario = Scenario()

project_key = dataiku.get_custom_variables()["projectKey"]
client = dataiku.api_client()
project = client.get_project(project_key)
variables = project.get_variables()
disease_variable = variables["standard"]["selected_disease"]

model_id  = 'QOCx9pEZ'
model = dataiku.Model(model_id)
model_list = model.list_versions()

model_version = [model_list[i]['versionId'] for i in range(len(model_list))]
model_name = [model_list[i]['snippet']['userMeta']['labels'][4]['value'] for i in range(len(model_list))]
model_dict = dict(zip(model_name, model_version))

model.activate_version(model_dict[disease_variable])