[Census Data - SVI factors](flow_zone:D8dQK96) flow zone uses the [Census Bureau's Application Programming Interface (API)](https://www.census.gov/data/developers/guidance/api-user-guide.Example_API_Queries.html#list-tab-2080675447) to access the American Community Survey (ACS) data and extract information about the Social Vulnerability Factors for individual tracts and counties. A prerequirement to all the users is to generate an API key. You can register for an API key, free of charge by following these steps:
1. Go to the [Developers site](https://www.census.gov/data/developers.html)
2. Click on the  **Request a KEY**  box on the left side of the page.
3. Replace the [project variable](article:5)``` "api_key": "XXX"``` with your unique key. 

![api.png](YZcD3MrmjWBM)

Moreover, each python script uses the ```requests``` library's ```get``` method to fetch data via the following HTTP:

```f"https://api.census.gov/data/{year}/acs/acs5/profile?get=NAME,group({census_code})&for=county:*&in=state:{state}&key={census_api_key}"```
All the input data can be downloaded [here](https://www.atsdr.cdc.gov/placeandhealth/svi/data_documentation_download.html). 

Note that ```{year}``` and ```{census_code}``` are both user-defined.  In this project, we call data from the ```2020``` release for multiple codes that follow the [CDC SVI Documentation 2020](https://www.atsdr.cdc.gov/placeandhealth/svi/documentation/SVI_documentation_2020.html). Each python script outputs the information in the table below. Any value with ```E_``` indicates the actual value estimate of population records and values with ```EP_``` indicate the percentage of the total population.

|    Dataset    |   Social Vulnerability Features | 
|------------|-------------------|
| [compute_B06009_svi_tracts](recipe:compute_B06009_svi_tracts)     | E_NOHSDP |
| [compute_B09001_svi_tracts](recipe:compute_B09001_svi_tracts)     | E_AGE17  |  
| [compute_B11012_svi_tracts](recipe:compute_B11012_svi_tracts)   | E_SNGPNT  | 
| [compute_B16005_svi_tracts](recipe:compute_B16005_svi_tracts)    | E_LIMENG, EP_LIMENG |
| [compute_B26001_svi_tracts](recipe:compute_B26001_svi_tracts)    | E_GROUPQ  |  
| [compute_DP02_svi_tracts](recipe:compute_DP02_svi_tracts) | E_HH, E_DISABL, EP_DISABL  | 
|  [compute_DP03_svi_tracts](recipe:compute_DP03_svi_tracts)| E_UNEMP, EP_UNEMP |
| [compute_DP04_svi_tracts](recipe:compute_DP04_svi_tracts) | E_HU, E_MOBILE, EP_MOBILE, E_NOVEH, EP_NOVEH, E_MUNIT, EP_MUNIT, E_CROWD, EP_CROWD  |  
  | [compute_DP05_svi_tracts](recipe:compute_DP05_svi_tracts) | E_MINRTY  | 
  |     | E_NOHSDP |
| [compute_S0601_svi_tracts](recipe:recipe_from_notebook_notebook_editor_for_compute_S0601_svi_tracts)     | GEO_ID, State_code, County_code, E_TOTPOP, EP_NOHSDP  |  
| [compute_S2503_svi_tracts](recipe:recipe_from_notebook_notebook_editor_for_compute_S2503_svi_tracts)| E_HBURD,  EP_HBURD  | 
| [compute_S0101_svi_tracts](recipe:recipe_from_notebook_notebook_editor_for_compute_S0101_svi_tracts) | E_AGE65, EP_AGE65 |
| [compute_S1701_svi_tracts](recipe:compute_S1701_svi_tracts) | E_POV150,  EP_POV150  | 
| [compute_S2701_svi_tracts](recipe:recipe_from_notebook_notebook_editor_for_compute_S2701_svi_tracts) | E_UNINSUR, EP_UNINSUR |

The mapping on the actual meaning of the above codes can be found in [census_svi_dictionary](dataset:census_svi_dictionary).

We follow a similar process at a county level and extract the exact same Social Vulnerability factors through [compute_B_svi_county](recipe:compute_B_svi_county),[compute_S_svi_county](recipe:compute_S_svi_county),[compute_D_SVI_county](recipe:compute_D_SVI_county) recipes.

  
  ![censussvi.png](eMgnCM8DvJ0q)  