<span id="version" style="color: grey; float: right">Version 2.1.0 </span><br/>

**[Social Determinants of Health](https://health.gov/healthypeople/priority-areas/social-determinants-health) (SDoH)** are the conditions and the environment in which people are born, grow, live, work, and age that influence health outcomes such as disease risk and quality-of-life.  These conditions can account for a much higher percentage of health outcomes (up to 90%) than medical care (10-15%) and contribute to about 40 percent of the variation in health status among individuals. [Chronic diseases](https://www.cdc.gov/prc/issue-briefs/addressing-social-determinants-of-health.html) such as heart disease and stroke, cancer, diabetes, and obesity are leading causes of death and disability in the United States. Differences in SDOH contribute to the distinction and persistent **health measure (including chronic diseases and other health behaviors or outcomes)** disparities among socioeconomic groups, systematically limiting opportunities for members of some groups to be healthy. 
Understanding socio-economic and behavioral factors (including economic stability, employment, education,  security, housing, transportation, social support, and safety) associated with health measure prevalence not only aligns with social responsibility programs but also can deliver  **ROI**  with improved patient outcomes by:
 - identifying resources, therapeutics, and interventions needed for at-risk populations
 - developing risk-adjusted payment or care models
 - impacting operational/spending/quality metrics for preventative care

Hospitals, health care systems, health insurers, public health and government agencies, and pharmaceutical companies are all increasingly tasked with leveraging population health insights into social vulnerabilities tied to health measure prevalence to inform business practices that address health disparities. 

![NYoverview.png](QT7weOpiDkJp)

# Project Value
1. A health equity web application exploring US regional social vulnerability indices and different health measure prevalence insights.
2. Interactive visual dashboards to identify and visualize patterns in community-level social factor trends with health measures with Dataiku’s descriptive analytics and charts and unsupervised Machine Learning.
3. Machine Learning-driven insights on how social vulnerability metrics impact population health measure metrics at a community (tract) level.
![5.png](LBi7OImyUYEV)

4. Reproducible, automated flow for pulling public data via API from the US Census on community social factor conditions, CDC chronic disease prevalence, and other health measure and risk behaviors surveys to compute SVI metrics, segmentation, and health measure prevalence modeling.
5. A Dataiku Application that allows users to upload their own health measure data at the tract or county level and reproduce the SDOH analysis on individual instances. 

![0.png](whh2KUYD49u7)



