A Dataiku application is configured to allow instances to be created by any user. The **Social Determinants Of Health** application built on this project enables users to generate an individual instance and upload their health measure data at county or tract level. The goal is to run the same analysis to discover how social vulnerabilities align with health measure prevalence across the US with minimal interaction with the main flow and project objects.

The input datasets are required to be compatible with the  **format and the order of columns**  below (see [Data Logs](article:4) and [Metadata](article:18)). Further instructions on application's functionality can be found in [Dataiku Application Article](article:29).

#   **County Level Data** 
  1.``` FIPS: String``` Federal Information Processing Standards - 5 digits code representing the state and county information. In case of 4 digitis (i.e. state has a single digit or county has two digit code) fill the gap at the beginning with zero. 
  
  2.```Percent_Measure_Value: Double``` The decimal values that indicate the percentage of the population in the state and county characterized by the FIPS code that has been recorded with the defined Health_Measure.  
  
  3.```Health_Measure: String``` indicates the health reason of the relevant records. 
  ![county_data_format.png](g7o38SnnQxbT)
  The **number of county records** should consist of 3142 counties for all the 50 states. If there are records missing user may prefill them with 0.  Also it possible to upload  **multiple**  health measures in the same file in a long format. 
  
  The input datasets are required to be compatible with the  **format and the order of columns**  below.

#   **Tract Level Data** 
  1.``` FIPS: String``` Federal Information Processing Standards - 11 digits code representing the state, county and tracts information. In case of 10 digitis (i.e. tract has a 5 digit code) fill the gap at the beginning with zero. 
  
  2.```Percent_Measure_Value: Double``` The decimal values that indicate the percentage of the population in the state, county and tract characterized by the FIPS code that has been recorded with the defined Health_Measure. 
  
  3.```Health_Measure: String``` indicates the health reason of the relevant records. 
![tract_data_format.png](Ve3jETt5Z8lj)
  The **number of tract records** has varied the last ten years from 75K - 84K approximately for the 3142 counties for all the 50 states. The user is highly suggested to upload as many data as popossible. If there are records missing user may prefill them with 0.  Also it possible to upload  **multiple**  health measures in the same file in a long format. 