## CENSUS / ACS

Accessing and analyzing data related to SDoH measures can broaden the understanding of community health. The [American Community Survey (ACS)](https://www.census.gov/data/developers/data-sets/acs-5year.html) is an ongoing survey that provides vital information yearly about the U.S. population. Detailed population and housing information are published through the U.S. Census Bureau at the geographic level of the state, county, place, census tract, and ZCTA.

Examples of data can be found in the following categories:
 - [Demographics](https://data.census.gov/cedsci/table?q=DP05&tid=ACSDP5Y2020.DP05)
 - [Social characteristics](https://data.census.gov/cedsci/table?q=DP02&tid=ACSDP5Y2020.DP02)
 - [Economic characteristics](https://data.census.gov/cedsci/table?q=DP03&tid=ACSDP1Y2019.DP03&tp=false)
 - [Housing data](https://data.census.gov/cedsci/table?q=DP04&tid=ACSDP5Y2020.DP04)
 
Note: The ACS provides 5-year "period" estimates that represent data collected over a period of time. The primary advantage of using multiyear estimates is the increased statistical reliability of the data for less populated areas and small population subgroups.

[Notes on ACS annotation values](https://www.census.gov/data/developers/data-sets/acs-1year/notes-on-acs-estimate-and-annotation-values.html)

## Centers for Disease Control and Prevention (CDC)

The [National Center for Chronic Disease Prevention and Health Promotion (NCCDPHP)](https://www.cdc.gov/chronicdisease/index.htm) helps states to collect data on chronic diseases and leading health indicators through a variety of surveillance systems. This information helps CDC understand how chronic diseases affect people and places across the United States and how well public health interventions work.

Note: Census Tracts are small, relatively permanent statistical subdivisions of a county or statistically equivalent entity that can be updated by local participants prior to each decennial census as part of the Census Bureau's Participant Statistical Areas Program (PSAP)

## Metadata
The following characteristics of all data consist the main keys for joining datasets from multiple resources at different stages of the flow. The unique ID and lowest level of information is the FIPS code (Federal Information Processing Standards), a published series of standardized codes used for interchange between government agencies and other technical communities in order to ensure uniform practice and organization.

![tract.png](qkyPyDqHsXIg)
 |    Feature    |   Dictionary| 
|------------|-------------------|
| FIPS     | Federal Information Processing Standards  |  
| Tract     | Tract Number |  
  | State_Code   | State Code  | 
  | County_Code   | County Code  | 
  | GeoPoint    | Location coordinates|  
|Population | Total Population |




## Project Data
In this solution data are called from the relevant API interface through live endpoints. There are two sets of data:
 1. [Flow Zone: Census Data - SVI factors](flow_zone:D8dQK96) calls data from the [American Community Survey 5-Year Data (2009-2020)](https://www.census.gov/data/developers/data-sets/acs-5year.html). Folder [Census_SVI_Datasets](managed_folder:GZNnZE4V) contains the official dictionary file [CDC:ATSDR SVI 2020.pdf ](https://www.atsdr.cdc.gov/placeandhealth/svi/documentation/SVI_documentation_2020.html)published by [Census](https://www.atsdr.cdc.gov/placeandhealth/svi/documentation/pdf/SVI2020Documentation_08.05.22.pdf). All the input data features, names, meanings, value mapping and computations follow the guidelines of this document. The main Census variable Names and Descriptions along the relevant social Theme can be found in the census_svi_dictionary:
 ![svi_factors.png](0CViKmUlCEJu)
 
 2. [Flow Zone: CDC Disease Data](flow_zone:puo7jcP) calls data from the [Centers for Disease Control and Prevention](https://open.cdc.gov/apis.html). The metadata of disease outcomes and health behaviors can be found on the [cdc_di](dataset:cdc_di). Throughout this project, we use Health Outcomes for relation analysis with Social Vulnerability factors and the rest of behavioral categories for visual analysis. Example:
 
![example_cdc.png](WIDL7B25jbYK)

