[Social determinants of health](web_app:wRmlvsW)  follows the [standard webapp](https://doc.dataiku.com/dss/latest/webapps/index.html#standard-web-apps) development process as [Health Measure Selection](web_app:PxEkB0h). All the python functions can be found in Libraries tab. The "standard" webapp is hosted by the platform to write custom front ends and advanced visualizations. Javascript code and python backend have access to various DSS API's to fetch and query datasets from the flow. 

## Social Determinant of Health Webapp
The elements of this webapp show:
![dropdow.png](92VPO9vi7TdK)
The dropown line with unique health measure, state and county options. Note that:
   -  ```(health_measure = user selection) & (state = ALL) & (county = ALL)``` filters show the entire U.S. analysis on a county level
   -``` (health_measure = user selection) & (state = user selection) & (county = ALL))``` filters show the results on a county level for the prespecified state
   - ``` (health_measure = user selection) & (state = user selection) & (county = user selection))```filters show the results on a tract level for the prespecified state and county
   
![webapplot.png](Qlo3uoVdQBZV)
Table always show results on tract level and filters the dataset based on user selections.

![heatmap.png](ZuxEo2nQQtGB)
Heatmap shows the health measure (including chronic diseases and other health measure and outcomes) prevalence in each area. The dark colour (red) indicates higher percentage accross the population in a specific area and ligh colour shows lower. Therapeutic access (and equity) may use insights on health measure prevalence to target HCPs/patients in region of high risk for marketing/sales and market access for customer behavior discovery.

![scatterplot.png](9Ag66l7XKpwz)
Scatteroplot combines the health measure prevalence percentile compared to all the other tracts on the x-axis with the overal social vulnerability (socioeconomic status, household composition & disability, ethnicity and language and housing or transportation status) on the y-axis. Plot points are coloured by the health measure prevalence and sizes by the population density. The user should be able to discover regions (country(US)/state/county/census tract levels) with both high health measure prevalence and high metrics of social vulnerability to direct health equity/therapeutic access programs/resources.

## Health Measure Selection

The purpose of [Health Measure Selection](web_app:PxEkB0h) standard webapp is to read the user's disease selection, save and update the project global variables that they are then fit to the [Scenarios](article:14) that update the active model and visual analysis for the selected disease. 

![webapp.png](b2QxM7Mg6PZ8)

 The python script reads the [svi_vulnerability_cdc_prepared_distinct](dataset:svi_vulnerability_cdc_prepared_distinct) that contains only the unique name of available disease in this project. It also set three functions for creating a list of the unique values and calling/setting the project variables. The webapp is published on [Chronic Disease Prevalence Modeling](dashboard:Nqzxt20). 

In a similar way standard webapps [Health Measure Selection County Level](web_app:5OXSkG3) and [Health Measure Selection Tract Level](web_app:PxEkB0h) read the user's health measure selection set the global variables and relevant scenarios that update Health Measures Prevalence analysis on [5. Social Determinants of New Health Measure - County](dashboard:q4kyVet) and [4. Social Determinants of New Health Measure - Tract](dashboard:RcBEWW5).

Note:  If you get an error message or are unable to select a disease from the drop down, you may need to restart the [webapp backened](web_app:PxEkB0h) from the webapp tab. 






