import dataiku
import pandas as pd
import kafka_wrapper
import datetime

# Read recipe inputs
enriched_process_data = dataiku.Dataset("enriched-process-data_windows_prepared_joined")
df_process_data = enriched_process_data.get_dataframe()
df_process_data = df_process_data.sort_values(['Press', 'DateTime_min'])

quality_alerts_logs = dataiku.Dataset("quality-alerts_log")
quality_alerts_df = quality_alerts_logs.get_dataframe()
quality_alerts_df = quality_alerts_df.sort_values(['press', 'alert_time'])

# Output topic setup:
output_kafka = dataiku.StreamingEndpoint("quality-alerts")
output_kafka.set_schema([{'name': 'press', 'type': 'string'}, {'name': 'alert_time', 'type': 'string'}, {'name': 'defect_rate', 'type': 'double'}])
kafka_producer = kafka_wrapper.get_native_kafka_producer(output_kafka)
output_topic = output_kafka.get_location_info(True).get("info", {}).get('topic', '')

# get the last row for each 'Press' per 'DateTime' column and check if it's the same defect_rate 
# (which means it's the same alert, so we don't resend it)

for press in df_process_data['Press'].unique():
    last_row = df_process_data[df_process_data['Press'] == press].iloc[-1]
    last_row["alert"] = 1 if last_row["predicted_defect_rate"] > last_row["usual_defect_rate"] else 0

    if quality_alerts_df[quality_alerts_df['press'] == press].empty == True:
        last_alert_sent = pd.Series({'press' : '', 'alert_time' : '', 'predicted_defect_rate' : 0.00})
    else:
        last_alert_sent = quality_alerts_df[quality_alerts_df['press'] == press].iloc[-1]

        
    if int(last_row["alert"]) == 1 and float(last_alert_sent['predicted_defect_rate']) != last_row['predicted_defect_rate']:
        alert_data= {'press': last_row["Press"],'alert_time': datetime.datetime.now().isoformat(),'predicted_defect_rate': last_row["predicted_defect_rate"]}
        # Publish the message to Kafka
        print('Publishing event:')
        print(alert_data)
        message = json.dumps(alert_data).encode('utf8')
        future = kafka_producer.send(topic=output_topic, value=message)
        try:
            r = future.get(timeout=10)
            print ("> Message '%s' sent to partition %d at offset %d" % (message, r.partition, r.offset))
        except KafkaError:
            print ("Fail to produce message to kafka")
            pass