# Project goal
This project aims to enable streaming for the [Production Quality Control solution](https://www.dataiku.com/learn/samples/production-quality-control/). 
To implement it, you’ll need:
 - The Production Quality Control solution
 - A working streaming connection 


# Use case

You've implemented the [Production Quality Control solution](https://www.dataiku.com/learn/samples/production-quality-control/) and now have a model that can predict whether a product will have a defect or not based on your production data. Your production data is connected to a stream-processing platform such as Apache Kafka.

In the [Live Scoring](flow_zone:default) part of the flow,  you'll be able to leverage streaming by making quality predictions in near-real time, thanks to the model trained in the Production Quality Control Solution.

Then in the [Business rule & alerting](flow_zone:SmkpthG) part of the flow , you'll be able to use the visual recipes and the usual defect rate per machine from the historical data of the Production Quality Control Solution to define alerts that will be sent to a Kafka topic and logged into a dataset.

Finally with the [Alerting](scenario:ALERTING) scenario, you'll be able to send alerts to usual reporters such as Microsoft teams or slack.



More information on how to implement this streaming component in the [Implementation](article:3) article.