# Implementation Guide

Once you have filled in the [requirements](article:2), you can start implementing the project. At that stage, the flow should look like this:
![flow_1.png](DB0solHmSAhm)

The implementation is done in 3 steps:
 1. Share the model and the dataset from your implemented Production Quality Control solution
 2. Setup the streaming endpoints to fit your kafka topics
 3. Configure the scenarios
 4. Adjust the project's variables to fit the project, dataset, and model name
 
## 1. Share the model and the dataset

From your Production Quality Control solution, share the trained model [Defect Prediction](saved_model:SOL_PQC.6vTbZgcN) and the [defect_rate_per_machines](dataset:SOL_PQC.defect_rate_per_machines) dataset to this project
![sharing.png](RSqCJahKvNLA) 

## 2. Setup the streaming endpoints to fit your kafka topics
If your streaming connection is properly setup, you are able to fetch the topics in the streaming endpoints:
![topic-setup.png](rgsJ9q6awwXt)
You need to choose the topic for your production data and the topic to send the quality alerts. You can check if the topic selected is the right one by clicking "try sampling".

## 3. Configure the scenarios
the project comes with 3 scenarios that you might need to adapt: 
- [Alerting](scenario:ALERTING) is sending alerts through a reporter, you can customize it (see "customize the reporter and message" below)
- [Data update](scenario:DATAUPDATE) is updating the required datasets to send alerts. It needs to auto triggers in production
- [Start streaming](scenario:STARTSTREAMING) is setting up everything and launch the continuous activities


## 4. Adjust the project's variables to fit the project, dataset, and model name

There are 2 global variables defined in this project:
 -  **PQC_project_key** : The Production Quality Control project key containing the trained model and defect rate per machine dataset

 -   **trained_model_key**: The key of the trained model. This key can be found in the implemented solution or in the continuous python recipe
 
# Adapt to your needs
Once the project setup, you may want to adjust several parameters to fit your needs:

### Number of predicted quality results
By default, we take 10 rows of quality prediction to compute the defect rate.
You can adjust this in the first step (window recipe) of the [business rule & alerting  zone](flow_zone:SmkpthG).
![business-rule-alerting.png](rB50qvN5CopA)

### Customize the quality alert kafka message
  You can adjust the content of the quality alert message in the first continuous recipe of the [business rule & alerting  zone](flow_zone:SmkpthG) at line 33, ```alert_data```. By default, we send the machine name, alert timestamp and defect rate.

### Customize the reporter and message
You can adjust the reporter and the message send. Edit the [Alerting scenario](scenario:ALERTING) step to select the reporter you want to use, [among those available in dataiku.](https://doc.dataiku.com/dss/latest/scenarios/reporters.html) by default, we defined a Microsoft Teams. 
Then, you can adjust the message right from the field:
![alerting-scenario.png](KNk8L2u6qNYn)
As you may have noticed, we are using scenario variables to send a detailed message containing the machine name and the defect rate, similarly to the streaming alert. These variables are defined in the first step of this scenario and set in the second custom python step. The data is directly read in the ```quality-alert_log``` dataset.

<br>