from google.oauth2.credentials import Credentials
from typing import Dict, List, TypedDict


class GoogleSheetDataset(TypedDict):
    """
    Dictionary object having the data of a single Google sheet.
    """
    sheet_name: str # Name of the sheet
    sheet_index: int # Index of the sheet within the spreadsheet
    header_columns_data: Dict[str, List[str]] # Mapping between each header column name and its values as a list
    header_column_occurences: Dict[str, int] # Occurences count of each header column

GoogleSpreadsheetDataCollection = Dict[str, GoogleSheetDataset]