This Solution requires a setup to function correctly.

# Connection configuration

Users must select the connections for the project datasets and the LLM models powering the agent and document retrieval.

## Main connection (SQL)
Select the **Main connection** used by the solution to access the structured datasets (orders history and open orders).

<div class="alert">
⚠️ An SQL connection is required for the agent’s dataset query tool and for most analytics outputs.
</div>

## LLM Mesh models
Select the LLM Mesh models used by the solution:

- **Powerful model for planning and reasoning**  
  Used for multi-step analysis, comparisons, and structured outputs (e.g., supplier briefs, trade-off analysis, what-if summaries).

- **Light model for simple tasks**  
  Used for lighter transformations and straightforward Q&A where a cheaper/faster model is sufficient.

- **Embedding model for vectorization**  
  Used to embed supplier annual reports for retrieval (Knowledge Bank search / RAG).

Once selected, click **RECONFIGURE** to apply the configuration.

<div class="alert">
⚠️ If you change the embedding model, you may need to adjust chunking parameters in the annual report embedding recipe to preserve retrieval quality and avoid context truncation.
</div>

# Data connection (Optional)

To use this solution with your own data, select the source project and map the required input datasets.

- Select your **project**
- Map the required datasets so they match the expected schema described in **Requirements & data model**
- Click **IMPORT DATA** to run the scenario that wires the selected datasets into the solution flow

<div class="alert">
⚠️ Make sure the selected datasets match the expected schema. If the schema differs, adapt the preparation steps in the Flow (especially in the “Orders history” zone) before running downstream steps.
</div>

# Launch the solution

Once connections are configured (and data optionally imported), click **LAUNCH SUPPLIER MANAGEMENT ASSISTANT** to open the solution experience and start using the assistant and deliverables.