# Orders history

This zone creates an **analysis-ready historical orders dataset** used by:
- the **Dashboards** (supplier spend + supplier performance),
- the **SQL dataset query tool** (agent tool for structured exploration),
- and the **open-orders extraction** used for delay-risk scoring.

## Inputs

- `input_supplier_orders_sync` (from *Input data*)
- `Updated_duty_tariffs_sync` (optional enrichment)

## Key steps in this zone

### 1) Prepare orders history (`supplier_orders_prepared`)
Typical transformations include creating new KPI columns

### 2) Join optional enrichment (`supplier_orders_prepared_joined`)
The join step enriches historical orders with duty/tariff context when the input is available.

### 3) Extract open orders (`open_orders_for_prediction`)
A filter step produces the open-orders dataset used for prediction by selecting orders that are not delivered yet.