<span id="version" style="color: grey; float: right">1.0.0</span>

# Supplier Management Assistant

The Supplier Management Assistant is a Dataiku solution that helps **Supply Chain** and **Procurement** teams assess supplier risk, monitor delivery reliability, and prioritize mitigation actions through a single conversational interface. It combines **supplier annual reports**, **historical purchase orders and delivery data**, and a **delay-risk prediction model** to provide both qualitative context and quantitative answers, thanks to a single agent.

The solution is designed for procurement managers, supply chain risk analysts, operational managers, and business stakeholders who need to quickly answer questions such as:
- Which suppliers are trending toward higher delay risk?
- Which parts are the main contributors to disruption?
- Which open orders are most likely to be late, and what changes would reduce risk?
- What do supplier communications and annual reports suggest about capacity, financial stress, or strategic shifts?

# Solution Scope

Managing a global supplier portfolio is increasingly complex. Teams must balance delivery reliability, cost pressure, and operational resilience while dealing with disruptions (capacity constraints, logistics issues, geopolitical events, regulatory shifts). In practice, the information required to act is often fragmented:

- Financial and strategic signals exist in documents (annual reports, statements, communications)
- Operational performance exists in structured datasets (purchase orders, delivery dates, delays)
- Forward-looking exposure sits in open orders that require prioritization and triage

The Supplier Management Assistant brings these sources together so teams can **detect risk earlier**, **triage open orders**, and **drive mitigation discussions faster**—without switching between multiple tools.

The solution is a strong fit when:
- You have **historical purchase order and delivery data** to compute delay KPIs and trends
- You want to support operational workflows such as “what should I worry about this week?”
- You need to combine **qualitative supplier context** (strategy, investments, restructuring) with **delivery performance**
- You want to evaluate **open orders** and run **what-if scenarios** to compare mitigation options

> This solution is not intended to replace contractual/legal analysis. It focuses on operational risk, delivery performance, and mitigation levers.


# Key Outcomes

- **Faster supplier risk reviews** by combining qualitative context (annual reports) with operational performance (on-time rate, delay patterns)
- **Supplier spend analysis** via dashboards to monitor spend concentration, top suppliers/parts, and trends over time
- **Supplier performance monitoring** via dashboards to track delivery KPIs and highlight deteriorating suppliers, parts, or lanes
- **Clear prioritization of open orders** using a model-driven risk signal to focus on the undelivered orders most likely to slip
- **What-if scenario analysis** to compare mitigation options and quantify expected risk reduction on open orders
- **A single interface for daily workflows** in Agent Hub, reducing time spent switching tools and building ad-hoc analyses
