This case study offers a walkthrough of the solution using a realistic procurement workflow, from a portfolio review to open-order triage and mitigation planning — all through a single Agent Connect chat experience.

# User Story

The Supplier Management Assistant supports day-to-day workflows for Supply Chain and Procurement teams who need to monitor supplier risk, track performance, and act quickly when disruption signals appear.

Typical user stories include:
- **Portfolio monitoring**: “Which suppliers are deteriorating on delivery performance? Who should I watch this week?”
- **Spend and dependency analysis**: “Where is our spend concentrated? Which suppliers/parts represent the highest exposure?”
- **Supplier deep dive**: “For a specific supplier, what are the main parts ordered, performance trends, and potential risks from their annual reports?”
- **Alternative sourcing**: “Which alternative suppliers exist for a critical part, and how do they compare on cost and delays?”
- **Open-order triage**: “Which undelivered orders are most likely to be delayed, and what should I prioritize?”
- **What-if mitigation**: “If we change a lever (supplier / origin / logistics parameter supported by the model), how does the predicted delay risk evolve?”

# Data

The solution combines three complementary sources of information:

- **Supplier annual reports (unstructured)**  
  Stored in a Knowledge Bank and used to retrieve qualitative context (strategy, investments, restructuring, capacity constraints, ESG signals, communications).

- **Purchase orders and delivery history (structured)**  
  Queried through a SQL dataset (e.g., `supplier_orders_prepared_joined`) to compute and explain spend and delivery performance metrics (on-time rate, average delay, trends by supplier/part/site/time window).

- **Open / undelivered orders (structured)**  
  Used to retrieve specific orders (e.g., `open_orders_for_prediction_prepared`) for baseline investigation and risk scoring.

In addition, the solution includes a **delay-risk prediction model** trained on historical patterns to estimate the likelihood of delay for open orders and support what-if simulations.

# Insights

The value delivered by the solution is not just “answers,” but **actionable prioritization**:
- Faster identification of suppliers that combine **high spend exposure** with **degrading performance**
- Immediate drill-down to understand what is driving risk (parts, lanes, time windows)
- Prioritized list of **open orders** to focus on, backed by a consistent risk signal
- Rapid evaluation of mitigation options through **what-if scenario comparisons**

The walkthrough below illustrates a typical end-to-end workflow.

## Step 1 following Data Ingestion — Portfolio Overview (Spend + Performance)

A **Procurement Manager** starts with a routine review in **Agent Hub**:

> “Give me a quick overview of our supplier portfolio. Where is spend concentrated, and which suppliers show the worst delivery performance recently?”

The assistant combines dashboard views and dataset-backed metrics to highlight:
- Top suppliers by spend and how concentrated the spend is
- Suppliers with deteriorating on-time performance or increasing delays
- A short shortlist of “watch list” suppliers for follow-up

Outcome: the user gets a prioritized list instead of scanning multiple reports.

## Step 2 following Data Ingestion — Assess Risk Signals from Annual Reports

To understand whether issues look temporary or structural, the user asks:

> “For the top 2 suppliers with worsening delays, summarize any risk signals from the latest annual reports.”

The assistant searches the Knowledge Bank and summarizes:
- Financial or operational headwinds (capacity constraints, restructuring, supply constraints)
- Strategic shifts that could impact service levels
- Any relevant qualitative explanation that helps interpret performance trends

Outcome: delivery KPIs are enriched with context, enabling better escalation and vendor conversations.

## Step 3 following Data Ingestion — Drill Down on a Critical Supplier

The manager focuses on a key supplier that appears both high-spend and poor-performing:

> “For GEARPRO, list the most ordered parts and show price, quantities, and delivery delay statistics.”

The assistant returns a structured view (typically a table) showing:
- Top parts by volume/spend
- Unit price indicators and ordering patterns
- Delivery metrics (average delay, late rate, variability)

Outcome: the user identifies which components are most exposed.

## Step 4 following Data Ingestion — Explore Alternatives for Critical Parts

To prepare contingencies:

> “For the top 3 parts, propose alternative suppliers and compare them on cost and delivery performance.”

The assistant uses historical procurement data to surface candidates and provides a comparison view to support:
- Shortlisting of realistic alternatives
- First-order trade-off analysis (cost vs delay performance)

Outcome: faster scenario planning and sourcing discussions.

## Step 5 following Data Ingestion — Open Orders Triage (Undelivered Orders)

Now the manager wants to reduce near-term operational risk:

> “Show me the open orders that are most likely to be delayed this month.”

The assistant retrieves and ranks open orders using:
- Order attributes from the undelivered orders dataset
- Baseline scoring with the delay-risk model (where applicable)

Outcome: a practical triage list that can be handed to operations for follow-up.

## Step 6 following Data Ingestion — What-If Mitigation on a Specific Open Order

For a high-risk order, the user asks:

> “For order ORDER_NUMBER=..., what is the baseline delay risk? What if we switch supplier to SPEEDLINE (or change another supported lever)?”

The assistant follows a consistent workflow:
1. Retrieve the open order record
2. Score a **baseline** delay risk
3. Apply the requested what-if change(s)
4. Re-score and present a comparison (baseline vs scenarios)
5. Provide mitigation guidance aligned to the scenario outcomes

Outcome: rapid evaluation of mitigation levers with quantified deltas.

# Conclusion

In a small number of conversational steps, the Supplier Management Assistant enables a Procurement or Supply Chain manager to:
- Monitor supplier spend exposure and performance trends
- Enrich operational KPIs with qualitative signals from annual reports
- Identify risky suppliers, parts, and lanes faster
- Prioritize undelivered orders using a consistent, model-backed signal
- Compare mitigation options through what-if simulations

The result is a smoother end-to-end experience: fewer manual exports and ad-hoc analyses, faster prioritization, and clearer decision support delivered directly in **Agent Hub**.