/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.utils;

import com.google.common.base.Strings;
import java.security.Security;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import net.snowflake.ingest.internal.apache.http.HttpHost;
import net.snowflake.ingest.internal.apache.http.HttpRequest;
import net.snowflake.ingest.internal.apache.http.HttpResponse;
import net.snowflake.ingest.internal.apache.http.NoHttpResponseException;
import net.snowflake.ingest.internal.apache.http.auth.AuthScope;
import net.snowflake.ingest.internal.apache.http.auth.UsernamePasswordCredentials;
import net.snowflake.ingest.internal.apache.http.client.HttpRequestRetryHandler;
import net.snowflake.ingest.internal.apache.http.client.ServiceUnavailableRetryStrategy;
import net.snowflake.ingest.internal.apache.http.client.config.RequestConfig;
import net.snowflake.ingest.internal.apache.http.client.protocol.HttpClientContext;
import net.snowflake.ingest.internal.apache.http.conn.routing.HttpRoute;
import net.snowflake.ingest.internal.apache.http.conn.ssl.DefaultHostnameVerifier;
import net.snowflake.ingest.internal.apache.http.conn.ssl.SSLConnectionSocketFactory;
import net.snowflake.ingest.internal.apache.http.impl.client.BasicCredentialsProvider;
import net.snowflake.ingest.internal.apache.http.impl.client.CloseableHttpClient;
import net.snowflake.ingest.internal.apache.http.impl.client.HttpClientBuilder;
import net.snowflake.ingest.internal.apache.http.impl.conn.DefaultProxyRoutePlanner;
import net.snowflake.ingest.internal.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import net.snowflake.ingest.internal.apache.http.pool.PoolStats;
import net.snowflake.ingest.internal.apache.http.protocol.HttpContext;
import net.snowflake.ingest.internal.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static String USE_PROXY = "http.useProxy";
    private static String PROXY_HOST = "http.proxyHost";
    private static String PROXY_PORT = "http.proxyPort";
    private static final String HTTP_PROXY_USER = "http.proxyUser";
    private static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
    private static String PROXY_SCHEME = "http";
    private static int MAX_RETRIES = 3;
    private static CloseableHttpClient httpClient;
    private static PoolingHttpClientConnectionManager connectionManager;
    private static IdleConnectionMonitorThread idleConnectionMonitorThread;
    private static ReentrantLock idleConnectionMonitorThreadLock;
    private static final int DEFAULT_CONNECTION_TIMEOUT_MINUTES = 1;
    private static final int DEFAULT_HTTP_CLIENT_SOCKET_TIMEOUT_MINUTES = 5;
    private static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 100;
    private static final int DEFAULT_MAX_CONNECTIONS = 100;
    private static final long IDLE_HTTP_CONNECTION_MONITOR_THREAD_INTERVAL_MS;
    private static final int DEFAULT_IDLE_CONNECTION_TIMEOUT_SECONDS = 30;
    private static final Logger LOGGER;

    public static CloseableHttpClient getHttpClient() {
        if (httpClient == null) {
            HttpUtil.initHttpClient();
        }
        HttpUtil.initIdleConnectionMonitoringThread();
        return httpClient;
    }

    private static void initHttpClient() {
        Security.setProperty("ocsp.enable", "true");
        SSLContext sslContext = SSLContexts.createDefault();
        SSLConnectionSocketFactory f = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1.2"}, null, (HostnameVerifier)new DefaultHostnameVerifier());
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout((int)TimeUnit.MILLISECONDS.convert(1L, TimeUnit.MINUTES)).setConnectionRequestTimeout((int)TimeUnit.MILLISECONDS.convert(1L, TimeUnit.MINUTES)).setSocketTimeout((int)TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES)).build();
        connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(100);
        connectionManager.setMaxTotal(100);
        HttpClientBuilder clientBuilder = HttpClientBuilder.create().setConnectionManager(connectionManager).setSSLSocketFactory(f).setServiceUnavailableRetryStrategy(HttpUtil.getServiceUnavailableRetryStrategy()).setRetryHandler(HttpUtil.getHttpRequestRetryHandler()).setDefaultRequestConfig(requestConfig);
        if ("true".equalsIgnoreCase(System.getProperty(USE_PROXY))) {
            if (System.getProperty(PROXY_PORT) == null) {
                throw new IllegalArgumentException("proxy port number is not provided, please assign proxy port to http.proxyPort option");
            }
            if (System.getProperty(PROXY_HOST) == null) {
                throw new IllegalArgumentException("proxy host IP is not provided, please assign proxy host IP to http.proxyHost option");
            }
            String proxyHost = System.getProperty(PROXY_HOST);
            int proxyPort = Integer.parseInt(System.getProperty(PROXY_PORT));
            HttpHost proxy = new HttpHost(proxyHost, proxyPort, PROXY_SCHEME);
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
            clientBuilder = clientBuilder.setRoutePlanner(routePlanner);
            String proxyUser = System.getProperty(HTTP_PROXY_USER);
            String proxyPassword = System.getProperty(HTTP_PROXY_PASSWORD);
            if (!Strings.isNullOrEmpty(proxyUser) && !Strings.isNullOrEmpty(proxyPassword)) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyUser, proxyPassword);
                AuthScope authScope = new AuthScope(proxyHost, proxyPort);
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(authScope, credentials);
                clientBuilder = clientBuilder.setDefaultCredentialsProvider(credentialsProvider);
            }
        }
        httpClient = clientBuilder.build();
    }

    private static void initIdleConnectionMonitoringThread() {
        idleConnectionMonitorThreadLock.lock();
        try {
            if (connectionManager != null && (idleConnectionMonitorThread == null || HttpUtil.idleConnectionMonitorThread.isShutdown())) {
                idleConnectionMonitorThread = new IdleConnectionMonitorThread(connectionManager);
                idleConnectionMonitorThread.setDaemon(true);
                idleConnectionMonitorThread.start();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Unable to start Daemon thread for Http Idle Connection Monitoring", (Throwable)e);
        }
        finally {
            idleConnectionMonitorThreadLock.unlock();
        }
    }

    private static ServiceUnavailableRetryStrategy getServiceUnavailableRetryStrategy() {
        return new ServiceUnavailableRetryStrategy(){
            private int executionCount = 0;
            int REQUEST_TIMEOUT = 408;

            @Override
            public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
                boolean needNextRetry;
                this.executionCount = executionCount;
                int statusCode = response.getStatusLine().getStatusCode();
                LOGGER.info("In retryRequest for service unavailability with statusCode:{} and uri:{}", (Object)statusCode, (Object)HttpUtil.getRequestUriFromContext(context));
                if (executionCount == MAX_RETRIES + 1) {
                    LOGGER.info("Reached the max retry time, not retrying anymore");
                    return false;
                }
                boolean bl = needNextRetry = (statusCode == this.REQUEST_TIMEOUT || statusCode >= 500) && executionCount < MAX_RETRIES + 1;
                if (needNextRetry) {
                    long interval = (1 << executionCount) * 1000;
                    LOGGER.info("Sleep time in millisecond: {}, retryCount: {}", (Object)interval, (Object)executionCount);
                }
                return needNextRetry;
            }

            @Override
            public long getRetryInterval() {
                long interval = (1 << this.executionCount) * 1000;
                return interval;
            }
        };
    }

    private static HttpRequestRetryHandler getHttpRequestRetryHandler() {
        return (exception, executionCount, httpContext) -> {
            String requestURI = HttpUtil.getRequestUriFromContext(httpContext);
            if (executionCount > MAX_RETRIES) {
                LOGGER.info("Max retry exceeded for requestURI:{}", (Object)requestURI);
                return false;
            }
            if (exception instanceof NoHttpResponseException) {
                LOGGER.info("Retrying request which caused No HttpResponse Exception with URI:{}, retryCount:{} and maxRetryCount:{}", new Object[]{requestURI, executionCount, MAX_RETRIES});
                return true;
            }
            LOGGER.info("No retry for URI:{} with exception", (Object)requestURI, (Object)exception);
            return false;
        };
    }

    private static String getRequestUriFromContext(HttpContext httpContext) {
        HttpClientContext clientContext = HttpClientContext.adapt(httpContext);
        HttpRequest httpRequest = clientContext.getRequest();
        return httpRequest.getRequestLine().getUri();
    }

    public static void shutdownHttpConnectionManagerDaemonThread() {
        HttpUtil.idleConnectionMonitorThread.shutdown();
    }

    private static String createPoolStatsForRoute(PoolingHttpClientConnectionManager connectionManager, HttpRoute route) {
        PoolStats routeStats = connectionManager.getStats(route);
        return HttpUtil.createPoolStatsInfo(String.format("Pool Stats for route %s = ", route.getTargetHost().toURI()), routeStats);
    }

    private static String createPoolStatsInfo(String title, PoolStats poolStats) {
        if (poolStats != null) {
            return title + poolStats + "\n";
        }
        return title;
    }

    static {
        idleConnectionMonitorThreadLock = new ReentrantLock(true);
        IDLE_HTTP_CONNECTION_MONITOR_THREAD_INTERVAL_MS = TimeUnit.SECONDS.toMillis(5L);
        LOGGER = LoggerFactory.getLogger(HttpUtil.class);
    }

    private static class IdleConnectionMonitorThread
    extends Thread {
        private final PoolingHttpClientConnectionManager connectionManager;
        private volatile boolean shutdown;

        public IdleConnectionMonitorThread(PoolingHttpClientConnectionManager connectionManager) {
            this.connectionManager = connectionManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                LOGGER.debug("Starting Idle Connection Monitor Thread ");
                IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                synchronized (idleConnectionMonitorThread) {
                    while (!this.shutdown) {
                        this.wait(IDLE_HTTP_CONNECTION_MONITOR_THREAD_INTERVAL_MS);
                        StringBuilder sb = new StringBuilder();
                        sb.append(HttpUtil.createPoolStatsInfo("Total Pool Stats = ", this.connectionManager.getTotalStats()));
                        Set<HttpRoute> routes = this.connectionManager.getRoutes();
                        if (routes != null) {
                            for (HttpRoute route : routes) {
                                sb.append(HttpUtil.createPoolStatsForRoute(this.connectionManager, route));
                            }
                        }
                        LOGGER.debug("[IdleConnectionMonitorThread] Pool Stats:\n" + sb);
                        this.connectionManager.closeExpiredConnections();
                        this.connectionManager.closeIdleConnections(30L, TimeUnit.SECONDS);
                    }
                }
            }
            catch (InterruptedException ex) {
                LOGGER.debug("Terminating Idle Connection Monitor Thread ");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void shutdown() {
            if (!this.shutdown) {
                LOGGER.debug("Shutdown Idle Connection Monitor Thread ");
                this.shutdown = true;
                IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                synchronized (idleConnectionMonitorThread) {
                    this.notifyAll();
                }
            }
        }

        private boolean isShutdown() {
            return this.shutdown;
        }
    }
}

