/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agents.tools.calculator;

import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolMeta;
import com.dataiku.dip.agents.tools.AgentToolParams;
import com.dataiku.dip.agents.tools.AgentToolRunner;
import com.dataiku.dip.agents.tools.calculator.CalculatorToolRunner;
import com.dataiku.dip.agents.tools.utils.JsonSchema;
import com.dataiku.dip.agents.tools.utils.JsonSchemaElement;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.transactions.TransactionContext;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class CalculatorTool {
    public static final AgentToolMeta META = new AgentToolMeta(false){

        @Override
        public String getType() {
            return "GRELCalculator";
        }

        @Override
        public Class<? extends AgentToolParams> paramsClass() {
            return Params.class;
        }

        @Override
        public List<SavedModel.AgentDependency> getDependencies(AgentTool tool) {
            return new ArrayList<SavedModel.AgentDependency>();
        }

        @Override
        public AgentToolMeta.ToolDescriptor getResultingDescriptor(AuthCtx authCtx, String projectKey, AgentTool tool) throws Exception {
            TransactionContext.assertNoAttachedTransaction();
            AgentToolMeta.ToolDescriptor td = new AgentToolMeta.ToolDescriptor(tool.name);
            td.description = "Computes a GREL (Google Refine Expression Language) formula. In this description you can find information about different types of operators and functions available in the formula language. \n";
            td.description = td.description + "You can use regular math operators: +, -, *, / ; and math functions like: abs(a), ceil(a), floor(a), round(a), mod(a, b), pow(a, b), sqrt(a), sin(a), cos(a), log(a), ln(a), exp(a) which is the exponential of a number with the base 'e', min(a, b, ...), max(a, b, ...), avg(a, b, ...), gcd(a, b), lcm(a, b), degrees(angleInRadians), radians(angleInDegrees), PI(), combin(n, k), fact(n), dec2hex(n), hex2dec(n) \n";
            td.description = td.description + "You can use \u201cTrue\u201d and \u201cFalse\u201d, with quotes, as boolean values for true and false. You can use boolean operators && and ||; and comparison operators like >, <, ==, != ; You MUST use quotes, for example: \"True\" || \"False\" which evaluates to \"True\"\n";
            td.description = td.description + "Use the ISO 8601 format to provide dates to the following date functions: now(), datePart(date d, string part, [timezone]), diff(date d1, date d2, [string unit]), inc(date d, number value, string unit), asDatetimeTz(object o, [format]) \n";
            td.description = td.description + "For example inc('2020-04-15T00:00:00.000Z', -3, 'week') will return 2020-03-25T00:00:00.000Z and the function diff('2020-04-15T00:00:00.000Z', '2020-04-10T00:00:00.000Z', 'days') will return 5 because the first date is 5 days later compared to the second date. \n";
            td.description = td.description + "You can use geometry functions like: geoBuffer(geometry geom, double distance, [int quadrantSegment]) -> string, geoContains(geometry geomA, geometry geomB) -> bool, geoSimplify(geometry geom, double toleranceDistance) -> string, geoDistance(geopoint geoPointA, geopoint geoPointB, string unit) -> number\n";
            td.description = td.description + "For example: geoContains(\"POLYGON((0 0,3 0,0 3,0 0))\", \"POINT(1 1)\") will return \"True\"";
            if (StringUtils.isNotBlank((String)tool.additionalDescriptionForLLM)) {
                td.description = td.description + "\n\n" + tool.additionalDescriptionForLLM;
            }
            td.inputSchema = JsonSchema.newObject("https://dataiku.com/agents/tools/grel/calculator/input", "Calculate a mathematical formula");
            td.inputSchema.properties.put("formula", JsonSchemaElement.string("The GREL formula to compute"));
            return td;
        }

        @Override
        public AgentToolRunner buildRunner(AuthCtx authCtx, String projectKey, AgentTool tool, boolean devKernel) throws Exception {
            return new CalculatorToolRunner((DSSAuthCtx)authCtx, tool);
        }
    };

    public static class Params
    implements AgentToolParams {
    }
}

