/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.GenericMultiTimeseriesExtractor;
import com.dataiku.dip.analysis.docgen.extractor.TimeseriesCoefficientsSingleExtractor;
import com.dataiku.dip.analysis.docgen.transform.Placeholder;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelDetails;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelIntrinsicPerf;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.jayway.jsonpath.DocumentContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TimeseriesCoefficientsMultiExtractor
extends GenericMultiTimeseriesExtractor {
    @Override
    public List<List<String>> extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        this.canExtract(model, Arrays.asList(PreTrainPredictionModelingParams.Algorithm.AUTO_ARIMA, PreTrainPredictionModelingParams.Algorithm.SEASONAL_LOESS, PreTrainPredictionModelingParams.Algorithm.PROPHET));
        TimeseriesForecastingModelDetails timeseriesModelDetails = (TimeseriesForecastingModelDetails)model;
        if (timeseriesModelDetails.getCoreParams().timeseriesIdentifiers.isEmpty()) {
            throw new IOException(String.format("Wrong placeholder. Extractor '%s' does not support single time series. Use {{%s}} instead.", this.getClass().getSimpleName(), Placeholder.RESULT_TIMESERIES_COEFFICIENTS_SINGLE_TABLE.placeholderName));
        }
        List<TimeseriesForecastingModelIntrinsicPerf.ModelCoefficients> modelCoefficients = timeseriesModelDetails.iperf.modelCoefficients;
        ArrayList<List<String>> output = new ArrayList<List<String>>();
        if (modelCoefficients.isEmpty()) {
            return output;
        }
        for (int i = 0; i < modelCoefficients.size(); ++i) {
            output.add(this.getHeaderRow(modelCoefficients.get(i)));
            output.addAll(this.getValuesRows(modelCoefficients.get(i)));
            output.add(new ArrayList());
        }
        return output;
    }

    private List<String> getHeaderRow(TimeseriesForecastingModelIntrinsicPerf.ModelCoefficients modelCoefficient) throws IOException {
        ArrayList<String> row = new ArrayList<String>();
        try {
            String firstRowKey = modelCoefficient.values.keySet().iterator().next();
            JsonObject tsIdentifiersHeaders = (JsonObject)JSON.parse((String)firstRowKey, JsonObject.class);
            row.addAll(tsIdentifiersHeaders.keySet());
        }
        catch (JsonSyntaxException e) {
            throw new IOException(String.format("Extractor '%s' is only usable on multi time series models", this.getClass().getSimpleName()));
        }
        row.add(modelCoefficient.displayName);
        if (TimeseriesCoefficientsSingleExtractor.Helper.hasStderrs(modelCoefficient)) {
            row.add(modelCoefficient.displayName + " stderr");
        }
        if (TimeseriesCoefficientsSingleExtractor.Helper.hasStderrs(modelCoefficient)) {
            row.add(modelCoefficient.displayName + " p-value");
        }
        if (TimeseriesCoefficientsSingleExtractor.Helper.hasStderrs(modelCoefficient)) {
            row.add(modelCoefficient.displayName + " t-stat");
        }
        return row;
    }

    private List<List<String>> getValuesRows(TimeseriesForecastingModelIntrinsicPerf.ModelCoefficients modelCoefficient) throws IOException {
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        for (String identifierName : modelCoefficient.values.keySet()) {
            JsonObject tsIdentifiersHeaders = (JsonObject)JSON.parse((String)identifierName, JsonObject.class);
            ArrayList<String> row = new ArrayList<String>();
            for (String identifier : tsIdentifiersHeaders.keySet()) {
                row.add(tsIdentifiersHeaders.get(identifier).getAsString());
            }
            TimeseriesCoefficientsSingleExtractor.Helper.addNullableValueToRow(row, modelCoefficient.values.get(identifierName));
            if (TimeseriesCoefficientsSingleExtractor.Helper.hasStderrs(modelCoefficient)) {
                TimeseriesCoefficientsSingleExtractor.Helper.addNullableValueToRow(row, modelCoefficient.stderrs.get(identifierName));
            }
            if (TimeseriesCoefficientsSingleExtractor.Helper.hasPvalues(modelCoefficient)) {
                TimeseriesCoefficientsSingleExtractor.Helper.addNullableValueToRow(row, modelCoefficient.pvalues.get(identifierName));
            }
            if (TimeseriesCoefficientsSingleExtractor.Helper.hasTvalues(modelCoefficient)) {
                TimeseriesCoefficientsSingleExtractor.Helper.addNullableValueToRow(row, modelCoefficient.tvalues.get(identifierName));
            }
            rows.add(row);
        }
        return rows;
    }
}

