/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLPaths;
import com.dataiku.dip.analysis.ml.prediction.split.SplitDesc;
import com.dataiku.dip.analysis.model.GuessStatus;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class MLTaskLoc {
    public String analysisProjectKey;
    public String analysisId;
    public String mlTaskId;
    private static Logger logger = Logger.getLogger((String)"dku.analysis.guess");

    public MLTaskLoc() {
    }

    public MLTaskLoc(String analysisProjectKey, String analysisId, String mlTaskId) {
        Preconditions.checkNotNull((Object)analysisProjectKey);
        Preconditions.checkNotNull((Object)mlTaskId);
        Preconditions.checkNotNull((Object)analysisId);
        this.analysisProjectKey = analysisProjectKey;
        this.analysisId = analysisId;
        this.mlTaskId = mlTaskId;
    }

    public String toString() {
        return String.format("<MLTaskLoc:%s.%s.%s>", this.analysisProjectKey, this.analysisId, this.mlTaskId);
    }

    public File getDataFolder() {
        return ApplicationConfigurator.getFile((String[])new String[]{"analysis-data", this.analysisProjectKey, this.analysisId, this.mlTaskId});
    }

    public File getSplitsFolder() {
        return ApplicationConfigurator.getFile((String[])new String[]{"analysis-data", this.analysisProjectKey, this.analysisId, this.mlTaskId, "splits"});
    }

    public File getSessionsFolder() {
        return ApplicationConfigurator.getFile((String[])new String[]{"analysis-data", this.analysisProjectKey, this.analysisId, this.mlTaskId, "sessions"});
    }

    public File getSessionFolder(String sessionId) {
        return ApplicationConfigurator.getFile((String[])new String[]{"analysis-data", this.analysisProjectKey, this.analysisId, this.mlTaskId, "sessions", sessionId});
    }

    public File getSelectionFolder() {
        return ApplicationConfigurator.getFile((String[])new String[]{"analysis-data", this.analysisProjectKey, this.analysisId, this.mlTaskId, "selection"});
    }

    public File getLastSessionFolder() {
        return DKUtils.lastFileInSequence((File)this.getSessionsFolder(), (String)"s");
    }

    public GuessStatus getGuessStatus() {
        try {
            File gsFile = ApplicationConfigurator.getFile((String[])new String[]{"analysis-data", this.analysisProjectKey, this.analysisId, this.mlTaskId, "guess.json"});
            return (GuessStatus)JSON.parseFile((File)gsFile, GuessStatus.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void writeGuessStatus(GuessStatus gs) {
        try {
            File gsFile = ApplicationConfigurator.getFile((String[])new String[]{"analysis-data", this.analysisProjectKey, this.analysisId, this.mlTaskId, "guess.json"});
            MLPaths.createIfNeededMLTaskFolderAndRestrictPermissions(this);
            JSON.prettyToFile((Object)gs, (File)gsFile);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to write guess status", (Throwable)e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.analysisId == null ? 0 : this.analysisId.hashCode());
        result = 31 * result + (this.analysisProjectKey == null ? 0 : this.analysisProjectKey.hashCode());
        result = 31 * result + (this.mlTaskId == null ? 0 : this.mlTaskId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MLTaskLoc other = (MLTaskLoc)obj;
        if (this.analysisId == null ? other.analysisId != null : !this.analysisId.equals(other.analysisId)) {
            return false;
        }
        if (this.analysisProjectKey == null ? other.analysisProjectKey != null : !this.analysisProjectKey.equals(other.analysisProjectKey)) {
            return false;
        }
        return !(this.mlTaskId == null ? other.mlTaskId != null : !this.mlTaskId.equals(other.mlTaskId));
    }

    public void checkIdsValidity(String enforceProjectKey) throws DKUSecurityException {
        if (enforceProjectKey != null && !enforceProjectKey.equals(this.analysisProjectKey)) {
            throw new DKUSecurityException("Analysis must be within project " + enforceProjectKey + ", but was in " + this.analysisProjectKey);
        }
        DKUFileUtils.checkNoPossibleEscape((String)this.analysisProjectKey, (String)"analysisProjectKey");
        DKUFileUtils.checkNoPossibleEscape((String)this.analysisId, (String)"analysisId");
        DKUFileUtils.checkNoPossibleEscape((String)this.mlTaskId, (String)"mlTaskId");
    }

    public List<String> listSplits() {
        ArrayList<String> ret = new ArrayList<String>();
        if (!this.getSplitsFolder().isDirectory()) {
            return ret;
        }
        for (File f : this.getSplitsFolder().listFiles()) {
            if (!f.isFile() || !f.getName().endsWith(".json")) continue;
            try {
                SplitDesc desc = (SplitDesc)JSON.parseFile((File)f, SplitDesc.class);
                ret.add(desc.instanceId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    public void keepOnlySplits(Set<String> instanceIds) throws IOException {
        HashSet<CallSite> keptFileNames = new HashSet<CallSite>();
        for (String instanceId : instanceIds) {
            keptFileNames.add((CallSite)((Object)("train-" + instanceId + ".csv")));
            keptFileNames.add((CallSite)((Object)("test-" + instanceId + ".csv")));
            keptFileNames.add((CallSite)((Object)("full-" + instanceId + ".csv")));
            keptFileNames.add((CallSite)((Object)("train-" + instanceId + ".csv.gz")));
            keptFileNames.add((CallSite)((Object)("test-" + instanceId + ".csv.gz")));
            keptFileNames.add((CallSite)((Object)("full-" + instanceId + ".csv.gz")));
            keptFileNames.add((CallSite)((Object)(instanceId + ".json")));
        }
        if (!this.getSplitsFolder().isDirectory()) {
            return;
        }
        for (File f : this.getSplitsFolder().listFiles()) {
            if (!f.isFile() || keptFileNames.contains(f.getName())) continue;
            logger.debug((Object)("Deleting unkept split file " + f.getName()));
            DKUFileUtils.forceDelete((File)f);
        }
    }

    public List<FullModelId> listModelIds(String sessionId) {
        ArrayList<FullModelId> ret = new ArrayList<FullModelId>();
        File sessionFolder = this.getSessionFolder(sessionId);
        if (!sessionFolder.isDirectory()) {
            throw ErrorContext.iaef((String)"Session does not exist: %s", (Object)sessionId, (Object[])new Object[0]);
        }
        for (File preprocFolder : sessionFolder.listFiles()) {
            if (!preprocFolder.isDirectory()) continue;
            for (File modelFolder : preprocFolder.listFiles()) {
                if (!modelFolder.isDirectory() || !modelFolder.getName().matches("m\\d+")) continue;
                FullModelId fmi = new FullModelId(this, sessionId, preprocFolder.getName(), modelFolder.getName());
                try {
                    ret.add(fmi);
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to get status for model " + String.valueOf(fmi)), (Throwable)e);
                }
            }
        }
        return ret;
    }
}

