/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.clustering.flow;

import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringClusterRecipePayloadParams;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringRecipesBasicService;
import com.dataiku.dip.analysis.model.clustering.PreTrainClusteringModelingParams;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class ClusterRecipeSchemaComputer
extends RecipeSchemaComputer
implements RecipeSchemaComputer.RecipeSchemaComputerWithPayload {
    @Autowired
    private ClusteringRecipesBasicService service;
    @Autowired
    private TransactionService transactionService;
    private ClusteringClusterRecipePayloadParams desc;

    public ClusterRecipeSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        super(authCtx, activity);
    }

    @Override
    public void setPayload(String payload) {
        this.desc = (ClusteringClusterRecipePayloadParams)JSON.parse((String)payload, ClusteringClusterRecipePayloadParams.class);
    }

    @Override
    public List<Schema> getSchemasForOutputRole_NT(String role) throws Exception {
        Preconditions.checkArgument((boolean)role.equals("main"), (Object)("Recipe only has output role 'main', got: " + role));
        try (Transaction t = this.transactionService.beginRead();){
            this.recipesValidationService.checkComplianceWithRecipeDesc(this.authCtx, this.recipe);
        }
        return Lists.newArrayList((Object[])new Schema[]{this.getSchema_NT()});
    }

    private Schema getSchema_NT() throws Exception {
        PreTrainClusteringModelingParams.Algorithm algo = this.desc.modeling.algorithm;
        return this.service.getClusterRecipeOutputSchema_NT(this.authCtx, this.activity, this.desc, algo);
    }
}

