/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.llm;

import java.util.Map;
import java.util.Optional;

public class LLMStepwiseTrainingMetrics {
    public Map<Integer, FineTuningJobMetric> metrics;

    public void addValidationMetric(Integer step, Float loss, Optional<Float> perplexity) {
        this.metrics.get(step).setValidationMetric(loss.floatValue(), perplexity);
    }

    public static class FineTuningJobMetric {
        public final Integer step;
        public final MetricValue trainingMetric;
        public MetricValue validationMetric;
        public MetricValue fullValidationMetric;

        public FineTuningJobMetric(Integer step, MetricValue trainingMetric) {
            this.step = step;
            this.trainingMetric = trainingMetric;
        }

        public void setValidationMetric(float loss, Optional<Float> perplexity) {
            this.validationMetric = new MetricValue(MetricType.VALIDATION, loss, perplexity);
        }

        public void setFullValidationMetric(float loss, Optional<Float> perplexity) {
            this.fullValidationMetric = new MetricValue(MetricType.FULL_VALIDATION, loss, perplexity);
        }
    }

    public static class MetricValue {
        public final MetricType type;
        public final float loss;
        public float perplexity;

        public MetricValue(MetricType type, float loss) {
            this.type = type;
            this.loss = loss;
        }

        public MetricValue(MetricType type, float loss, Optional<Float> perplexity) {
            this.type = type;
            this.loss = loss;
            if (perplexity.isPresent()) {
                this.perplexity = perplexity.get().floatValue();
            }
        }
    }

    public static enum MetricType {
        TRAINING,
        VALIDATION,
        FULL_VALIDATION;

    }
}

