/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.clustering.algorithms.python;

import com.dataiku.dip.analysis.model.ClusteringModelingParams;
import com.dataiku.dip.analysis.model.clustering.ClusteringMLTask;
import com.dataiku.dip.analysis.model.clustering.ClusteringParameterChecks;
import com.dataiku.dip.analysis.model.clustering.PreTrainClusteringModelingParams;
import com.dataiku.dip.analysis.model.clustering.algorithms.python.ScikitAlgorithmMeta;
import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.utils.ErrorContext;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class CustomScikitModel
extends ScikitAlgorithmMeta {
    @Override
    public String generateName(PreTrainClusteringModelingParams rpmp) {
        return StringUtils.isNotBlank((String)rpmp.custom_model_name) ? rpmp.custom_model_name : "Custom Python model";
    }

    @Override
    public String generateDescription(PreTrainClusteringModelingParams rpmp) {
        return "";
    }

    @Override
    public void validateParameters(ClusteringModelingParams cmp, ClusteringMLTask task, ClusteringParameterChecks checks) {
        if (cmp.custom_python != null) {
            for (ClusteringModelingParams.ClusteringCustomPythonParams cp : cmp.custom_python) {
                if (cp == null || !cp.enabled) continue;
                if (!cp.custom_has_k) {
                    ErrorContext.checkNotEmpty((String)cp.code, (String)"Custom model is not configured (you must write the code)");
                    continue;
                }
                if (cp.k == null || cp.k.length == 0) {
                    throw new IllegalArgumentException("Model requires k but no values found. You must input some values.");
                }
                ErrorContext.checkNotEmpty((String)cp.code, (String)"Custom model is not configured (you must write the code)");
            }
        }
    }

    @Override
    public List<WorkSet.ModelingSet> expandModeling(ClusteringModelingParams cmp, ClusteringMLTask task) {
        ArrayList<WorkSet.ModelingSet> ret = new ArrayList<WorkSet.ModelingSet>();
        if (cmp.custom_python != null) {
            for (ClusteringModelingParams.ClusteringCustomPythonParams cp : cmp.custom_python) {
                if (cp == null || !cp.enabled) continue;
                if (!cp.custom_has_k) {
                    PreTrainClusteringModelingParams rcmp = new PreTrainClusteringModelingParams(PreTrainClusteringModelingParams.Algorithm.SCIKIT_MODEL);
                    rcmp.scikit_clf = cp.code;
                    rcmp.custom_model_name = cp.name;
                    rcmp.custom_has_k = false;
                    ret.add(new WorkSet.ModelingSet(rcmp));
                    continue;
                }
                for (int k : cp.k) {
                    PreTrainClusteringModelingParams rcmp = new PreTrainClusteringModelingParams(PreTrainClusteringModelingParams.Algorithm.SCIKIT_MODEL);
                    rcmp.scikit_clf = cp.code;
                    rcmp.custom_model_name = cp.name;
                    rcmp.k = k;
                    rcmp.custom_has_k = true;
                    ret.add(new WorkSet.ModelingSet(rcmp));
                }
            }
        }
        return ret;
    }

    @Override
    public boolean oneModelPerPreprocessingSet() {
        return true;
    }
}

