/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction;

import com.dataiku.dip.analysis.model.PreprocessingReport;
import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.analysis.model.prediction.BinaryClassificationModelPerf;
import com.dataiku.dip.analysis.model.prediction.ClassificationModelIntrinsicPerf;
import com.dataiku.dip.analysis.model.prediction.RegressionModelIntrinsicPerf;
import com.dataiku.dip.analysis.model.prediction.RegressionModelPerf;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class AbstractPredictionScorer {
    private static Logger logger = Logger.getLogger((String)"dku.analysis.prediction");

    public void scoreRegression(WorkSet.ModelingSet ms, List<String> features) throws Exception {
        this.writePreprocessingFile(ms, "preprocessing_report.json", new PreprocessingReport());
        this.writeModelFile(ms, "perf.json", this.computeRegressionModelPerf(ms, features));
        this.writeModelFile(ms, "iperf.json", this.computeRegressionModelIntrinsicPerf(ms));
    }

    public void scoreClassification(WorkSet.ModelingSet ms, List<String> features) throws Exception {
        this.writePreprocessingFile(ms, "preprocessing_report.json", new PreprocessingReport());
        this.writeModelFile(ms, "perf.json", this.computeBinaryClassificationModelPerf(ms, features));
        this.writeModelFile(ms, "iperf.json", this.computeClassificationModelIntrinsicPerf(ms));
    }

    public abstract RegressionModelPerf computeRegressionModelPerf(WorkSet.ModelingSet var1, List<String> var2) throws Exception;

    public abstract RegressionModelIntrinsicPerf computeRegressionModelIntrinsicPerf(WorkSet.ModelingSet var1) throws Exception;

    public abstract BinaryClassificationModelPerf computeBinaryClassificationModelPerf(WorkSet.ModelingSet var1, List<String> var2) throws Exception;

    public abstract ClassificationModelIntrinsicPerf computeClassificationModelIntrinsicPerf(WorkSet.ModelingSet var1) throws Exception;

    private void writeModelFile(WorkSet.ModelingSet ms, String fileName, Object val) throws IOException {
        File file = ms.fullId.getModelFile(fileName);
        JSON.prettyToFile((Object)val, (File)file);
    }

    private void writePreprocessingFile(WorkSet.ModelingSet ms, String fileName, Object val) throws IOException {
        File file = ms.fullId.getPreprocessingFile(fileName);
        JSON.prettyToFile((Object)val, (File)file);
    }
}

