/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.datamodel.config;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractDeploymentBasicInfo;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIServiceDeployment;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIServiceDockerDeployment;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeployment;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AbstractFullyManagedAPIDeployment;
import com.dataiku.dip.apideployer.datamodel.config.AbstractFullyManagedAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.SageMakerAPIDeploymentInfra;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.externalinfras.sagemaker.SageMakerInputValidator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.StringTransmogrifier;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class SageMakerAPIDeployment
extends AbstractFullyManagedAPIDeployment {
    public SageMakerAPIDeploymentOverrideMask overrideSettings = new SageMakerAPIDeploymentOverrideMask();
    @Nullable
    private String customEndpointName;
    @Nonnull
    private SageMakerAPIDeploymentInfra.RealTimeConfig realTimeConfig = new SageMakerAPIDeploymentInfra.RealTimeConfig();
    @Nonnull
    private SageMakerAPIDeploymentInfra.ServerlessConfig serverlessConfig = new SageMakerAPIDeploymentInfra.ServerlessConfig();

    @Nullable
    public String getCustomEndpointName(SageMakerAPIDeploymentInfra infra) {
        if (infra.allowOverrideEndpointName) {
            return this.customEndpointName;
        }
        return null;
    }

    @Nonnull
    public SageMakerAPIDeploymentInfra.RealTimeConfig getRealTimeConfig(SageMakerAPIDeploymentInfra infra) {
        if (infra.allowOverrideSizeAndScaling && this.overrideSettings.sizeAndScaling) {
            return this.realTimeConfig;
        }
        return infra.realTimeConfig;
    }

    @Nonnull
    public SageMakerAPIDeploymentInfra.ServerlessConfig getServerlessConfig(SageMakerAPIDeploymentInfra infra) {
        if (infra.allowOverrideSizeAndScaling && this.overrideSettings.sizeAndScaling) {
            return this.serverlessConfig;
        }
        return infra.serverlessConfig;
    }

    private SageMakerAPIDeployment() {
    }

    protected SageMakerAPIDeployment(String id, SageMakerAPIDeploymentInfra infra, String publishedServiceId, String version, String endpointId, boolean enabled, VersionTag creationTag) {
        super(id, infra.id, publishedServiceId, version, enabled, creationTag, endpointId);
    }

    protected SageMakerAPIDeployment(AbstractAPIServiceDeployment existingDeployment, List<SageMakerAPIDeployment> otherDeployments, String deploymentId, SageMakerAPIDeploymentInfra infra, @Nullable String endpointId, boolean enabled, VersionTag creationTag) {
        super(existingDeployment, deploymentId, infra.id, enabled, creationTag, endpointId);
        AbstractFullyManagedAPIDeploymentInfra.EndpointType endpointType = infra.endpointType;
        if (existingDeployment instanceof SageMakerAPIDeployment) {
            SageMakerAPIDeployment sageMakerExistingDeployment = (SageMakerAPIDeployment)existingDeployment;
            if (sageMakerExistingDeployment.customEndpointName != null) {
                StringTransmogrifier transmogrifier = new StringTransmogrifier("-", 0, Integer.valueOf(63), true, true);
                for (SageMakerAPIDeployment otherDeployment : otherDeployments) {
                    transmogrifier.addAlreadyTransmogrifiedAcceptDupes(otherDeployment.customEndpointName);
                }
                this.customEndpointName = transmogrifier.transmogrify(sageMakerExistingDeployment.customEndpointName);
            }
            if (endpointType == AbstractFullyManagedAPIDeploymentInfra.EndpointType.REAL_TIME) {
                this.realTimeConfig = sageMakerExistingDeployment.realTimeConfig;
            } else if (endpointType == AbstractFullyManagedAPIDeploymentInfra.EndpointType.SERVERLESS) {
                this.serverlessConfig = sageMakerExistingDeployment.serverlessConfig;
            }
            this.overrideSettings = sageMakerExistingDeployment.overrideSettings;
        }
    }

    @Override
    public AbstractDeploymentBasicInfo.SageMakerDeploymentBasicInfo basicInfoUnsafe() {
        AbstractDeploymentBasicInfo.SageMakerDeploymentBasicInfo sageMakerDeplBI = new AbstractDeploymentBasicInfo.SageMakerDeploymentBasicInfo();
        sageMakerDeplBI.id = this.id;
        sageMakerDeplBI.enabled = this.enabled;
        sageMakerDeplBI.publishedServiceId = this.publishedServiceId;
        sageMakerDeplBI.deployedServiceId = this.deployedServiceId;
        sageMakerDeplBI.infraId = this.infraId;
        sageMakerDeplBI.generationsMapping = this.generationsMapping;
        sageMakerDeplBI.tags = this.tags;
        sageMakerDeplBI.creationTag = this.creationTag;
        sageMakerDeplBI.versionTag = this.versionTag;
        sageMakerDeplBI.deploymentTag = this.deploymentTag;
        sageMakerDeplBI.endpointId = this.endpointId;
        return sageMakerDeplBI;
    }

    @Override
    public SageMakerAPIDeploymentOverrideMask getOverrideSettings() {
        return this.overrideSettings;
    }

    @Override
    public void verifyFields(AbstractDeploymentInfra infra, AbstractDeployment oldDeployment, boolean isDeployed) {
        SageMakerAPIDeploymentInfra sageMakerAPIDeploymentInfra;
        super.verifyFields(infra, oldDeployment, isDeployed);
        if (oldDeployment instanceof SageMakerAPIDeployment && infra instanceof SageMakerAPIDeploymentInfra) {
            sageMakerAPIDeploymentInfra = (SageMakerAPIDeploymentInfra)infra;
            SageMakerAPIDeployment sageMakerOldAPIDeployment = (SageMakerAPIDeployment)oldDeployment;
            if (isDeployed) {
                SageMakerAPIDeployment.verifyImmutableField(sageMakerOldAPIDeployment.getCustomEndpointName(sageMakerAPIDeploymentInfra), this.getCustomEndpointName(sageMakerAPIDeploymentInfra), "Custom endpoint name");
            }
        } else {
            throw ErrorContext.iaef((String)"Old deployment with id %s is not an SageMaker deployment.", (Object)oldDeployment.id, (Object[])new Object[0]);
        }
        this.verifyCustomEndpointNameFormat(sageMakerAPIDeploymentInfra);
    }

    private void verifyCustomEndpointNameFormat(SageMakerAPIDeploymentInfra infra) {
        String endpointName = this.getCustomEndpointName(infra);
        if (StringUtils.isBlank((String)endpointName)) {
            return;
        }
        SageMakerInputValidator.validateEndpointName(endpointName);
    }

    @Override
    public void additionalFinalizeForDeploymentType(File contextDir, AbstractAPIDeploymentInfra infra) throws IOException {
        File additionalTargetInit = new File(contextDir, "Docker.additional_finalize_deployment_type");
        String uid = DKUApp.getParams().getParam("dku.container.dataiku.uid", "500");
        StringBuilder builder = new StringBuilder();
        builder.append("USER " + uid + "\n");
        builder.append("RUN cd /home/dataiku/data && sed -i \"s/port =.*/port = 8080/g\" install.ini && ./bin/dssadmin regenerate-config\n");
        if (((AbstractFullyManagedAPIDeploymentInfra)infra).isServerless()) {
            builder.append("USER root\n");
            builder.append("RUN chown -Rh dataiku:0 /home/dataiku && chmod -R a+rwX /home/dataiku/data\n");
        } else {
            builder.append("USER " + uid + "\n");
        }
        builder.append("WORKDIR /home/dataiku\n");
        builder.append("ENTRYPOINT [\"/home/dataiku/data/bin/deploy_anywhere_wrapper.sh\"]\n");
        builder.append("EXPOSE 8080\n");
        DKUFileUtils.writeFileUTF8((File)additionalTargetInit, (String)builder.toString());
    }

    public static class SageMakerAPIDeploymentOverrideMask
    extends AbstractAPIServiceDockerDeployment.APIServiceDockerDeploymentOverrideMask {
        boolean sizeAndScaling;
    }
}

