/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.deployments;

import com.dataiku.dip.apideployer.datamodel.actual.SingleNodeProjectDeploymentHeavyStatus;
import com.dataiku.dip.apideployer.datamodel.config.SingleAutomationNodeInfra;
import com.dataiku.dip.apideployer.datamodel.config.SingleNodeProjectDeployment;
import com.dataiku.dip.apideployer.deployments.AbstractProjectDeploymentManager;
import com.dataiku.dip.apideployer.engine.DeploymentHooksRunner;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.directory.NodeConnection;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.nodeclients.AutomationNodeClient;
import com.dataiku.dip.projects.importexport.AbstractBundleService;
import com.dataiku.dip.projects.importexport.BundleActivator;
import com.dataiku.dip.projects.importexport.BundlePreloader;
import com.dataiku.dip.projects.importexport.model.BundleActivationTestResult;
import com.dataiku.dip.scheduler.scenarios.TestingStatus;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SingleNodeProjectDeploymentManager
extends AbstractProjectDeploymentManager<PreparePreloadAndActivateReport> {
    private final SingleNodeProjectDeployment deployment;
    private final SingleAutomationNodeInfra infra;
    private final NodeConnection nodeConnection;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.deployment.automation.manager");

    public SingleNodeProjectDeploymentManager(@Nonnull AuthCtx authCtx, SingleNodeProjectDeployment deployment, SingleAutomationNodeInfra infra) {
        super(authCtx, deployment);
        this.deployment = deployment;
        this.infra = infra;
        this.nodeConnection = infra.getConnectionInfo();
    }

    @Override
    @Nonnull
    protected PreparePreloadAndActivateReport initializeDeploymentReport() {
        return new PreparePreloadAndActivateReport(this.isProjectStandardsFeatureAllowed());
    }

    @Override
    protected SingleNodeProjectDeployment getDeployment() {
        return this.deployment;
    }

    @Override
    protected SingleAutomationNodeInfra getInfra() {
        return this.infra;
    }

    @Override
    protected SingleNodeProjectDeploymentHeavyStatus createNewHeavyStatus(String deploymentId, String infraId) {
        return new SingleNodeProjectDeploymentHeavyStatus(deploymentId, infraId);
    }

    @Override
    @Nonnull
    protected String getInfraPrettyName() {
        return "automation node " + this.getInfra().id;
    }

    @Override
    @Nonnull
    protected DeploymentHooksRunner.DeploymentHookMetadata getDeploymentHookMetadata() {
        return new DeploymentHooksRunner.SingleNodeProjectDeploymentHookMetadata(this.nodeConnection, this.deployment, this.infra.getProxyUserForTargetProject(this.authCtx, this.deployment.getTargetProjectKey()));
    }

    @Override
    @Nonnull
    protected List<AbstractProjectDeploymentManager.ScenarioRunsByNode> retrieveScenarioRunsWithinDateRange_NT(String fromDate, String toDate) throws IOException, CodedException {
        try (AutomationNodeClient client = this.automationNodeProxyUserClient(this.nodeConnection);){
            List<AbstractProjectDeploymentManager.ScenarioRunsByNode> list = Collections.singletonList(new AbstractProjectDeploymentManager.ScenarioRunsByNode(null, client.getScenarioRunsWithinDateRange(this.targetProjectKey, fromDate, toDate, true)));
            return list;
        }
    }

    @Override
    @Nonnull
    protected InfoMessage.InfoMessages synchronisationPreparation() throws CodedException {
        logger.info((Object)("Prepare sync of " + JSON.json((Object)this.deployment)));
        String CODE = "prepare";
        logger.info((Object)("Performing prepare for deployment " + this.deployment.id));
        InfoMessage.InfoMessages report = this.prepareSyncOnAutomationNode(this.nodeConnection);
        if (report.isEmpty()) {
            logger.info((Object)"Report for prepare is empty");
        } else {
            logger.infoV("prepare report: %s", new Object[]{report.report("\n")});
        }
        return report;
    }

    @Override
    @Nonnull
    protected BundlePreloader.BundlePreloadingReport bundlePreloading(DKUtils.SmartLogTailBuilder logTailBuilder) throws InterruptedException {
        logger.infoV("Preload bundle %s on automation node project %s", new Object[]{this.deployment.bundleId, this.targetProjectKey});
        String CODE = "preload";
        logger.info((Object)("Performing preload for deployment " + this.deployment.id));
        BundlePreloader.BundlePreloadingReport report = this.preloadOnAutomationNode(this.nodeConnection, logTailBuilder);
        if (report.maxSeverity != InfoMessage.Severity.ERROR || this.isProjectPresentOnAutomationNode(this.nodeConnection)) {
            neverEverDeployed.remove(this.getDeployment().id);
        }
        if (report.isEmpty()) {
            logger.info((Object)"Report for preload is empty");
        } else {
            logger.infoV("preload report: %s", new Object[]{report.report("\n")});
        }
        return report;
    }

    @Override
    @Nonnull
    protected BundleActivationTestResult activationChecking_NT() throws InterruptedException {
        String CODE = "activate-check";
        logger.info((Object)("Performing + activate-check for deployment " + this.deployment.id));
        BundleActivationTestResult report = this.activateCheckOnAutomationNode_NT(this.nodeConnection);
        if (report.isEmpty()) {
            logger.info((Object)"Report for activate-check is empty");
        } else {
            logger.infoV("activate-check report: %s", new Object[]{report.report("\n")});
        }
        return report;
    }

    @Override
    @Nonnull
    protected BundleActivator.BundleActivationReport doDeployment(DKUtils.SmartLogTailBuilder logTailBuilder) throws IOException, InterruptedException {
        logger.infoV("Activating bundle %s on automation node project %s for infra %s", new Object[]{this.deployment.bundleId, this.targetProjectKey, this.infra.id});
        BundleActivator.BundleActivationReport report = new BundleActivator.BundleActivationReport();
        InfoMessage.InfoMessages additionalMessages = new InfoMessage.InfoMessages();
        AbstractBundleService.BundleActivationOptions bundleActivationOptions = this.buildBundleActivationOptions(additionalMessages);
        report.mergeFrom(additionalMessages);
        BundleActivator.BundleActivationReport activationReport = this.doDeploymentOnAutomationNode(this.nodeConnection, bundleActivationOptions, logTailBuilder);
        report.mergeFrom(activationReport);
        if (report.maxSeverity != InfoMessage.Severity.ERROR) {
            logger.debugV("Deployment completed without error on infra %s, updating deploymentTag", new Object[]{this.infra.id});
            this.updateDeploymentTag();
        } else {
            logger.warnV("Deployment completed with error on infra %s, not updating deploymentTag", new Object[]{this.infra.id});
        }
        FutureProgress.incrementState((double)1.0);
        return report;
    }

    @Override
    public TestingStatus getTestingStatus(@Nullable String bundleId, @Nullable String automationNodeId) throws IOException, CodedException {
        if (automationNodeId != null) {
            throw new IllegalArgumentException("You cannot specify an automation node id to retrieve the testing status of a single node deployment.");
        }
        try (AutomationNodeClient client = this.automationNodeProxyUserClient(this.nodeConnection);){
            TestingStatus testingStatus = client.getTestingStatus(this.deployment.basicInfoUnsafe().getDeployedItemId(), bundleId);
            return testingStatus;
        }
    }

    @Override
    public TestingStatus runTestScenarios(@Nullable String automationNodeId) throws CodedException, IOException {
        if (automationNodeId != null) {
            throw new IllegalArgumentException("You cannot specify an automation node id to retrieve the testing status of a single node deployment.");
        }
        try (AutomationNodeClient client = this.automationNodeProxyUserClient(this.nodeConnection);){
            TestingStatus testingStatus = client.runTestScenarios(this.deployment.basicInfoUnsafe().getDeployedItemId());
            return testingStatus;
        }
    }

    public static class PreparePreloadAndActivateReport
    extends AbstractProjectDeploymentManager.ProjectDeploymentReport {
        InfoMessage.InfoMessages prepareSyncReport;
        InfoMessage.InfoMessages preloadReport;
        BundleActivationTestResult activateCheckReport;
        BundleActivator.BundleActivationReport activateReport;

        private PreparePreloadAndActivateReport() {
            super(false);
        }

        public PreparePreloadAndActivateReport(boolean projectStandardsAllowed) {
            super(projectStandardsAllowed);
        }

        @Override
        public PreparePreloadAndActivateReport copyHookStatusWithSensitiveDataAdded() {
            PreparePreloadAndActivateReport copy = this.copyWithNonAdminDeploymentFailureMessage();
            copy.deploymentHookExecutionStatus.updateMessageWithSensitiveData();
            return copy;
        }

        @Override
        public PreparePreloadAndActivateReport copyWithNonAdminDeploymentFailureMessage() {
            PreparePreloadAndActivateReport copy = new PreparePreloadAndActivateReport(this.isProjectStandardsFeatureAllowed());
            copy.mergeFrom(this);
            copy.copyInterruptedAndHookStatus(this);
            copy.projectStandardsCheckReport = (InfoMessage.InfoMessages)JSON.deepCopy((Object)this.projectStandardsCheckReport);
            copy.prepareSyncReport = (InfoMessage.InfoMessages)JSON.deepCopy((Object)this.prepareSyncReport);
            copy.preloadReport = (InfoMessage.InfoMessages)JSON.deepCopy((Object)this.preloadReport);
            copy.activateCheckReport = (BundleActivationTestResult)((Object)JSON.deepCopy((Object)((Object)this.activateCheckReport)));
            copy.activateReport = (BundleActivator.BundleActivationReport)((Object)JSON.deepCopy((Object)((Object)this.activateReport)));
            return copy;
        }

        @Override
        public void setActualDeploymentStepReport(@Nonnull InfoMessage.InfoMessages report) {
            if (!(report instanceof BundleActivator.BundleActivationReport)) {
                throw new AssertionError((Object)String.format("Unexpected type of activate report. Expected a %s, got a %s", BundleActivator.BundleActivationReport.class, report.getClass()));
            }
            this.activateReport = (BundleActivator.BundleActivationReport)report;
            this.mergeFrom(report);
        }

        @Override
        public InfoMessage.InfoMessages getSynchronisationPreparationReport() {
            return this.prepareSyncReport;
        }

        @Override
        public InfoMessage.InfoMessages getBundlePreloadingReport() {
            return this.preloadReport;
        }

        @Override
        public BundleActivationTestResult getActivationCheckingReport() {
            return this.activateCheckReport;
        }

        @Override
        public BundleActivator.BundleActivationReport getBundleActivationReport() {
            return this.activateReport;
        }

        @Override
        public void mergeFromSynchronisationPreparationReport(@Nonnull InfoMessage.InfoMessages report) {
            this.prepareSyncReport = report;
            this.mergeFrom(report);
        }

        @Override
        public void mergeFromBundlePreloadingReport(@Nonnull InfoMessage.InfoMessages report) {
            this.preloadReport = report;
            this.mergeFrom(report);
        }

        @Override
        public void mergeFromActivationCheckingReport(@Nonnull BundleActivationTestResult report) {
            this.activateCheckReport = report;
            this.mergeFrom(report);
        }
    }
}

