/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cluster;

import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClusterHandler;
import com.dataiku.dip.cluster.ClusterMeta;
import com.dataiku.dip.exceptions.UnavailableDSSObjectException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;

public class ClusterRegistry {
    private static final Map<String, ClusterMeta> library = Maps.newLinkedHashMap();

    public static ClusterHandler buildHandler(AuthCtx authCtx, @Nullable String projectKey, Cluster cluster) {
        ClusterHandler handler = ClusterRegistry.getMeta(cluster).buildHandler(authCtx, projectKey, cluster);
        SpringUtils.getInstance().autowire((Object)handler);
        return handler;
    }

    public static ClusterMeta getMeta(Cluster cluster) {
        return ClusterRegistry.getMeta(cluster.type);
    }

    public static synchronized ClusterMeta getMeta(String type) {
        if (library.containsKey(type)) {
            return library.get(type);
        }
        throw UnavailableDSSObjectException.fromObjectTypeAndType("cluster", type);
    }

    public static synchronized boolean hasMeta(String type) {
        return library.containsKey(type);
    }

    public static synchronized void register(ClusterMeta meta) {
        library.put(meta.getType(), meta);
    }

    public static synchronized void deregister(String type) {
        library.remove(type);
    }
}

