/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cluster;

import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;

public class HadoopOverrideMask {
    public boolean kerberosAuth;
    public boolean properties;
    public boolean validationKernelsExtraEnv;

    public static HadoopOverrideMask fromJsonObject(JsonObject settings) {
        HadoopOverrideMask mask = new HadoopOverrideMask();
        if (settings == null) {
            return mask;
        }
        if (settings.has("kerberosLoginEnabled") && !settings.get("kerberosLoginEnabled").isJsonNull()) {
            mask.kerberosAuth = true;
        }
        if (settings.has("extraConf") && !settings.get("extraConf").isJsonNull()) {
            mask.properties = true;
        }
        if (settings.has("validationKernelsExtraEnv") && !settings.get("validationKernelsExtraEnv").isJsonNull()) {
            mask.validationKernelsExtraEnv = true;
        }
        return mask;
    }

    public HadoopSettings apply(HadoopSettings base, HadoopSettings overrides) {
        HadoopSettings overriden = (HadoopSettings)JSON.deepCopy((Object)base);
        if (this.kerberosAuth) {
            overriden.kerberosLoginEnabled = overrides.kerberosLoginEnabled;
            overriden.dssKeytabPath = overrides.dssKeytabPath;
            overriden.dssPrincipal = overrides.dssPrincipal;
        }
        if (this.properties) {
            overriden.extraConf = base.extraConf.getOverriden(overrides.extraConf);
        }
        if (this.validationKernelsExtraEnv) {
            overriden.validationKernelsExtraEnv = base.validationKernelsExtraEnv.getOverriden(overrides.validationKernelsExtraEnv);
        }
        return overriden;
    }
}

