/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.code;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.code.AbstractNodeCodeEnvsAccessService;
import com.dataiku.dip.code.AutomationNodeManagedEnvUtils;
import com.dataiku.dip.code.CodeEnvCodes;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.code.StandardPythonInterpreter;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.projects.importexport.CommonBundleUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class AutomationNodeCodeEnvsAccessService
extends AbstractNodeCodeEnvsAccessService {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.code.envs");

    private File f(File f, String ... chunks) {
        return new File(f, StringUtils.join((Object[])chunks, (String)"/"));
    }

    public static File getEnvRootDir(CodeEnvModel.EnvLang envLang, String envName) {
        return ApplicationConfigurator.getFile((String[])new String[]{"acode-envs", envLang.getFolderName(), envName});
    }

    public CodeEnvModel.AutomationEnvRootDef getEnvRootDefOrNull(CodeEnvModel.EnvLang envLang, String envName) throws IOException {
        File envRootDir = AutomationNodeCodeEnvsAccessService.getEnvRootDir(envLang, envName);
        if (this.f(envRootDir, "env.json").isFile()) {
            return (CodeEnvModel.AutomationEnvRootDef)JSON.parseFile((File)this.f(envRootDir, "env.json"), CodeEnvModel.AutomationEnvRootDef.class);
        }
        return null;
    }

    public CodeEnvModel.AutomationEnvRootDef getEnvRootDef(CodeEnvModel.EnvLang envLang, String envName) throws Exception {
        File envDir = AutomationNodeCodeEnvsAccessService.getEnvRootDir(envLang, envName);
        File rootDefFile = new File(envDir, "env.json");
        return (CodeEnvModel.AutomationEnvRootDef)JSON.parseFile((File)rootDefFile, CodeEnvModel.AutomationEnvRootDef.class);
    }

    public List<CodeEnvModel.CodeEnvListItem> listCodeEnvs() throws IOException {
        return this.listCodeEnvs(null, null);
    }

    public List<CodeEnvModel.CodeEnvListItem> listCodeEnvs(String projectKey, String bundleId) throws IOException {
        File rootDefFile;
        String envName;
        ArrayList<CodeEnvModel.CodeEnvListItem> ret = new ArrayList<CodeEnvModel.CodeEnvListItem>();
        File descDir = ApplicationConfigurator.getFile((String[])new String[]{"acode-envs", CodeEnvModel.EnvLang.PYTHON.getFolderName()});
        if (descDir.isDirectory()) {
            for (File envDir : descDir.listFiles()) {
                envName = null;
                try {
                    envName = envDir.getName();
                    rootDefFile = new File(envDir, "env.json");
                    if (!rootDefFile.isFile()) continue;
                    CodeEnvModel.CodeEnvListItem item = new CodeEnvModel.CodeEnvListItem();
                    CodeEnvModel.AutomationEnvRootDef rootDef = (CodeEnvModel.AutomationEnvRootDef)JSON.parseFile((File)rootDefFile, CodeEnvModel.AutomationEnvRootDef.class);
                    StandardPythonInterpreter pythonInterpreter = null;
                    try {
                        pythonInterpreter = this.getPythonInterpreter(envName, projectKey, bundleId, rootDef);
                    }
                    catch (CodeEnvResolutionService.CodeEnvMissingVersionException e) {
                        continue;
                    }
                    item.pythonInterpreter = pythonInterpreter;
                    item.envName = envName;
                    item.envLang = CodeEnvModel.EnvLang.PYTHON;
                    item.deploymentMode = rootDef.deploymentMode;
                    item.owner = rootDef.owner;
                    item.containerConfs = rootDef.containerConfs;
                    item.allContainerConfs = rootDef.allContainerConfs;
                    item.allSparkKubernetesConfs = rootDef.allSparkKubernetesConfs;
                    item.sparkKubernetesConfs = rootDef.sparkKubernetesConfs;
                    ret.add(item);
                }
                catch (Exception e) {
                    if (envName != null) {
                        logger.warnV("Skipping python code env '%s', could not parse desc file: %s", new Object[]{envName, ExceptionUtils.getMessageWithCauses((Throwable)e)});
                        continue;
                    }
                    logger.warnV("Skipping unknown python code env, could not parse desc file: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                }
            }
        }
        if ((descDir = ApplicationConfigurator.getFile((String[])new String[]{"acode-envs", CodeEnvModel.EnvLang.R.getFolderName()})).isDirectory()) {
            for (File envDir : descDir.listFiles()) {
                envName = null;
                try {
                    CodeEnvModel.EnvVersionRef versionRef;
                    envName = envDir.getName();
                    rootDefFile = new File(envDir, "env.json");
                    if (!rootDefFile.isFile()) continue;
                    CodeEnvModel.AutomationEnvRootDef rootDef = (CodeEnvModel.AutomationEnvRootDef)JSON.parseFile((File)rootDefFile, CodeEnvModel.AutomationEnvRootDef.class);
                    if (rootDef.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_VERSIONED && StringUtils.isNotBlank((String)projectKey) && StringUtils.isNotBlank((String)bundleId) && (versionRef = AutomationNodeManagedEnvUtils.getNamedBundleLink(CodeEnvModel.EnvLang.R, envName, projectKey, bundleId)) == null) continue;
                    CodeEnvModel.CodeEnvListItem item = new CodeEnvModel.CodeEnvListItem();
                    item.envName = envName;
                    item.envLang = CodeEnvModel.EnvLang.R;
                    item.deploymentMode = rootDef.deploymentMode;
                    item.owner = rootDef.owner;
                    item.containerConfs = rootDef.containerConfs;
                    item.allContainerConfs = rootDef.allContainerConfs;
                    item.allSparkKubernetesConfs = rootDef.allSparkKubernetesConfs;
                    item.sparkKubernetesConfs = rootDef.sparkKubernetesConfs;
                    ret.add(item);
                }
                catch (Exception e) {
                    if (envName != null) {
                        logger.warnV("Skipping R code env '%s', could not parse desc file: %s", new Object[]{envName, ExceptionUtils.getMessageWithCauses((Throwable)e)});
                        continue;
                    }
                    logger.warnV("Skipping unknown R code env, could not parse desc file: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                }
            }
        }
        return ret;
    }

    public StandardPythonInterpreter getPythonInterpreter(String envName, String projectKey, String bundleId, CodeEnvModel.AutomationEnvRootDef rootDef) throws IOException {
        File envDir = ApplicationConfigurator.getFile((String[])new String[]{"acode-envs", CodeEnvModel.EnvLang.PYTHON.getFolderName(), envName});
        if (rootDef.deploymentMode == null) {
            return null;
        }
        switch (rootDef.deploymentMode) {
            case DSS_INTERNAL: 
            case PLUGIN_MANAGED: 
            case AUTOMATION_SINGLE: {
                CodeEnvModel.PythonEnvDesc desc = AutomationNodeManagedEnvUtils.getEnvDesc(envDir, CodeEnvModel.PythonEnvDesc.class);
                return desc.pythonInterpreter;
            }
            case AUTOMATION_VERSIONED: {
                if (!StringUtils.isNotBlank((String)projectKey)) break;
                CodeEnvModel.EnvVersionRef versionRef = AutomationNodeManagedEnvUtils.getNamedBundleLink(CodeEnvModel.EnvLang.PYTHON, envName, projectKey, bundleId = bundleId == null ? CommonBundleUtils.getActiveBundleId(projectKey) : bundleId);
                if (versionRef == null) {
                    throw new CodeEnvResolutionService.CodeEnvMissingVersionException(projectKey, bundleId);
                }
                File envVersionDir = AutomationNodeManagedEnvUtils.getEnvVersionDir(CodeEnvModel.EnvLang.PYTHON, envName, versionRef.envVersion);
                CodeEnvModel.PythonEnvDesc desc = AutomationNodeManagedEnvUtils.getEnvDesc(envVersionDir, CodeEnvModel.PythonEnvDesc.class);
                return desc.pythonInterpreter;
            }
            case AUTOMATION_NON_MANAGED_PATH: 
            case PLUGIN_NON_MANAGED: 
            case EXTERNAL_CONDA_NAMED: {
                break;
            }
            case DESIGN_MANAGED: 
            case DESIGN_NON_MANAGED: {
                throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_INCORRECT_ENV_TYPE, "Illegal env mode: " + String.valueOf((Object)rootDef.deploymentMode));
            }
        }
        return null;
    }

    @Override
    public boolean doesEnvExist(CodeEnvModel.EnvLang envLang, String envName) {
        File envRootDir = AutomationNodeCodeEnvsAccessService.getEnvRootDir(envLang, envName);
        File rootDefFile = new File(envRootDir, "env.json");
        return rootDefFile.isFile();
    }
}

