/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.codestudio.blocks;

import com.dataiku.dip.codestudio.blocks.CodeStudioBlockParams;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlockRegistry;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import org.apache.log4j.Logger;

public class CodeStudioBlock {
    public String type;
    public CodeStudioBlockParams params;
    private static Logger logger = Logger.getLogger((String)"dip.codestudio.template");

    public CodeStudioBlock() {
    }

    public CodeStudioBlock(CodeStudioBlock other) {
        this.type = other.type;
        this.params = (CodeStudioBlockParams)JSON.deepCopy((Object)other.params);
    }

    public <T extends CodeStudioBlockParams> T getParamsAs(Class<T> clazz) {
        try {
            return (T)(this.params == null ? (CodeStudioBlockParams)clazz.newInstance() : (CodeStudioBlockParams)clazz.cast(this.params));
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.warn((Object)"Unable to create empty params object", (Throwable)e);
            return null;
        }
    }

    public static void registerAdapter() {
        JSON.registerAdapter(CodeStudioBlock.class, (Object)new JsonDeserializer<CodeStudioBlock>(){

            public CodeStudioBlock deserialize(JsonElement json, Type type, JsonDeserializationContext ctx) throws JsonParseException {
                JsonElement jsonParams;
                JsonObject jsonObj = json.getAsJsonObject();
                CodeStudioBlock codeStudioBlock = new CodeStudioBlock();
                JsonElement jsonType = jsonObj.get("type");
                if (jsonType != null && !jsonType.isJsonNull()) {
                    codeStudioBlock.type = jsonType.getAsString();
                }
                if ((jsonParams = jsonObj.get("params")) != null && !jsonParams.isJsonNull() && codeStudioBlock.type != null) {
                    if (CodeStudioBlockRegistry.hasMeta(codeStudioBlock.type)) {
                        codeStudioBlock.params = (CodeStudioBlockParams)ctx.deserialize(jsonParams, CodeStudioBlockRegistry.getMeta(codeStudioBlock.type).blockParamsClass());
                    } else {
                        logger.error((Object)("Can't deserialize params for type " + codeStudioBlock.type));
                    }
                }
                return codeStudioBlock;
            }
        });
    }

    public static class CodeStudioBlockType {
        public String type;
        public String label;
        public String description;
        public String icon;
        public Boolean isUnique;
        public Boolean isLocked;
        public Boolean isAdvanced;
        public int uiDisplayPriority;
    }
}

